package net.wicp.tams.common.es.plugin;

import java.sql.Connection;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.elasticsearch.action.bulk.BulkItemResponse;

import com.alibaba.fastjson.JSONObject;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.Config;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.es.Action;
import net.wicp.tams.common.es.EsData;
import net.wicp.tams.common.es.EsData.Builder;
import net.wicp.tams.common.es.EsObj;
import net.wicp.tams.common.es.RelaValue;
import net.wicp.tams.common.es.UpdateSet;
import net.wicp.tams.common.es.client.ESClient;
import net.wicp.tams.common.es.client.threadlocal.EsClientThreadlocal;
import net.wicp.tams.common.jdbc.DruidAssit;

/***
 * dumps
 * 
 * @author andy.zhou
 *
 */
@Slf4j
public class DumperEs5 implements IBusiSender<DumpEvent> {

	private static final org.slf4j.Logger errorlog = org.slf4j.LoggerFactory.getLogger("errorBinlog");

	private String index;

	private String type;

	private String relaColName;

	private Connection connection;

	/****
	 * 要求在初始化前把ES地址给配置好
	 */
	@Override
	public void init(Dump dump) {
		Validate.notEmpty(dump.getBusiPluginConfig(), "需要扩展属性，它是一个json且包含有 index值。");
		Validate.notBlank(dump.getBusiPluginConfig().getString("index"), "需要扩展属性，它是一个json且包含有 index值。");
		// Validate.notBlank(dump.getBusiPluginConfig().getString("type"),
		// "需要扩展属性，它是一个json且包含有 type值。");
		this.index = dump.getBusiPluginConfig().getString("index");
		if (dump.getBusiPluginConfig().containsKey("relaColName")) {
			this.relaColName = dump.getBusiPluginConfig().getString("relaColName");
		}
		if (!dump.getBusiPluginConfig().containsKey("type")) {
			String db = StringUtil.isNull(dump.getDbOri()) ? dump.getDb() : dump.getDbOri();
			String tb = StringUtil.isNull(dump.getTbOri()) ? dump.getTb() : dump.getTbOri();
			this.type = String.format("%s-%s", db, tb);
		} else {
			this.type = dump.getBusiPluginConfig().getString("type");
		}

		this.connection = DruidAssit.getConnection(Config.globleDatasourceName);
	}

	/**
	 * 需要的参数：rules、middlewareType、middlewareInst
	 */
	@Override
	public void initParams(JSONObject params) {
	}

	@Override
	public void doSend(DumpEvent dataBuilders) {
		ESClient eSClient = EsClientThreadlocal.createPerThreadEsClient(this.connection);
		Builder esDataBuilder = EsData.newBuilder();
		esDataBuilder.setIndex(this.index);
		esDataBuilder.setType(this.type);
		esDataBuilder.setAction(Action.update);
		esDataBuilder.setUpdateSet(UpdateSet.newBuilder().setUpsert(true).build());
		String[] primarys = ArrayUtils.isEmpty(dataBuilders.getDump().getPrimarysLogic())
				? dataBuilders.getDump().getPrimarys()
				: dataBuilders.getDump().getPrimarysLogic();
		boolean hasprimarys = ArrayUtils.isNotEmpty(primarys);
		for (Map<String, String> datamap : dataBuilders.getDatas()) {
			EsObj.Builder esObjBuilder = EsObj.newBuilder();
			CollectionUtil.filterNull(datamap, 1);
			esObjBuilder.putAllSource(datamap);
			if (hasprimarys) {
				String[] values = new String[primarys.length];
				for (int j = 0; j < values.length; j++) {
					values[j] = datamap.get(primarys[j]);
				}
				String idstr = CollectionUtil.arrayJoin(values, "-");
				if (StringUtils.isEmpty(idstr)) {
					log.error("id是空值");
					continue;
				}
				esObjBuilder.setId(idstr);
				// 关联关系支持
				if (StringUtil.isNotNull(this.relaColName)) {// 根元素或是没有关联关联的索引
					String parentId = datamap.get(this.relaColName);
					esObjBuilder.setId(idstr);// 有可能与主表id相同把主表的ID冲掉
					if (StringUtils.isBlank(parentId)) {// 关联关系没有parent
						errorlog.error(esObjBuilder.toString());// 打错误日志跳过
						continue;
					}
					RelaValue relaValue = RelaValue.newBuilder().setName(this.relaColName).setParent(parentId).build();
					esObjBuilder.setRelaValue(relaValue);
				}
			}
			esDataBuilder.addDatas(esObjBuilder.build());
		}
		String aaa = esDataBuilder.getDatas(0).getSourceMap().get("update_time");
		Result ret = eSClient.docWriteBatch_tc(esDataBuilder.build());
		if (!ret.isSuc()) {
			BulkItemResponse[] retObjs = (BulkItemResponse[]) ret.retObjs();
			for (BulkItemResponse bulkItemResponse : retObjs) {
				if (bulkItemResponse.isFailed()) {
					log.error("send error,id:[{}],reason:[{}]", bulkItemResponse.getId(),
							bulkItemResponse.getFailure());// TODO 错误处理
				}
			}
			throw new RuntimeException("发送ES失败,由sendHander重试");
		}
	}
}
