package net.wicp.tams.common.es.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;

import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.connector.executor.busi.ClassLoadManager;
import net.wicp.tams.common.connector.executor.busi.KeyConfigManager;
import net.wicp.tams.common.connector.executor.impl.CommonService;

public class TamsRestHandlerPlugin extends Plugin implements ActionPlugin {

	public static KeyConfigManager keyConfigManager;
	public static CommonService executor;
	public static URLClassLoader cloasLoader;

	@Override
	public List<RestHandler> getRestHandlers(final Settings settings, final RestController restController,
			final ClusterSettings clusterSettings, final IndexScopedSettings indexScopedSettings,
			final SettingsFilter settingsFilter, final IndexNameExpressionResolver indexNameExpressionResolver,
			final Supplier<DiscoveryNodes> nodesInCluster) {
		Logger logger = Loggers.getLogger(TamsRestHandlerPlugin.class, settings);
		logger.info("-------------------begin plugin------------------------------------");
		Properties props = IOUtil.fileToProperties("/plugin-default.properties", TamsRestHandlerPlugin.class);
		Conf.overProp(props);
		logger.info("-----size:{}", Conf.copyProperties().size());
		logger.info("path={},packagebase={}", Conf.get("common.es.plugin.path"),
				Conf.get("common.es.plugin.packagebase"));

		TamsRestHandlerPlugin.executor = new CommonService();
		String path = Conf.get("common.es.plugin.path");
		path = (StringUtil.isNull(path) || "none".equals(path))
				? IOUtil.mergeFolderAndFilePath(IOUtil.getCurFolder(TamsRestHandlerPlugin.class).getParent(), "/plugin")
				: path;
		File pluginDir = new File(path);
		if (!pluginDir.exists()) {
			try {
				FileUtils.forceMkdir(pluginDir);
			} catch (IOException e) {
				logger.error("创建插件目录:" + path + "失败", e);
			}
		}
		String[] packages = Conf.get("common.es.plugin.packagebase").split(",");
		ClassLoadManager classLoadManager = new ClassLoadManager(path, 2, packages);
		// ClassLoadManager classLoadManager = new ClassLoadManager(path, 2, packages);
		TamsRestHandlerPlugin.cloasLoader = classLoadManager.getCloasLoader();
		TamsRestHandlerPlugin.keyConfigManager = new KeyConfigManager(TamsRestHandlerPlugin.cloasLoader);
		TamsRestHandlerPlugin.executor.setBusiManager(classLoadManager);
		TamsRestHandlerPlugin.executor.setConfigManager(TamsRestHandlerPlugin.keyConfigManager);
		logger.info("-------------------------xplat plugins start sucess------------------------------");
		// return singletonList(new RestPutMappingAction(settings, restController));
		return Arrays.asList(new ConnectorRest(settings, restController));
	}
}
