package net.wicp.tams.common.es.plugin;

import static net.wicp.tams.common.es.plugin.TamsRestHandlerPlugin.executor;
import static net.wicp.tams.common.es.plugin.TamsRestHandlerPlugin.keyConfigManager;
import static org.elasticsearch.rest.RestRequest.Method.GET;
import static org.elasticsearch.rest.RestRequest.Method.POST;

import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.cat.AbstractCatAction;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.config.xmlParser.XMLNameSpace;
import net.wicp.tams.common.connector.executor.IBusiApp;
import net.wicp.tams.common.es.norm.AbsBusiApp;
import net.wicp.tams.common.exception.param.Request;

/***
 * 数据库中的字段转为mapping并添回
 * 
 * @author 偏锋书生
 *
 *         2018年8月1日
 */

public class ConnectorRest extends AbstractCatAction {

	public ConnectorRest(Settings settings, RestController controller) {
		super(settings);
		controller.registerHandler(GET, Conf.get("common.es.plugin.connector.url"), this);
		controller.registerHandler(POST, Conf.get("common.es.plugin.connector.url"), this);
	}

	@Override
	public String getName() {
		return "xpalt_show_mapping_bymysql_action";
	}

	@Override
	protected RestChannelConsumer doCatRequest(RestRequest request, NodeClient client) {
		Thread.currentThread().setContextClassLoader(TamsRestHandlerPlugin.cloasLoader);
		BytesReference content = request.content();
		String contextstr = new String(content.toBytesRef().bytes);
		// logger.info("contextstr=" + contextstr);
		JSONObject inputparam = JSONObject.parseObject(contextstr);
		CusDynaBean inputBean = keyConfigManager.getInputBeanInputBody(inputparam);
		// logger.info("transactionNo=" + inputBean.getStrValueByName("transactionNo"));
		String appKey = inputparam.getJSONObject(XMLNameSpace.ControlInfo).getString(Request.requestCommand);
		IBusiApp bean = executor.getBusiManager().getBean(appKey);
		if (AbsBusiApp.class.isAssignableFrom(bean.getClass())) {
			((AbsBusiApp) bean).setNodeClient(client);
			((AbsBusiApp) bean).setLogger(logger);
		}
		CusDynaBean outbean = executor.exe(inputBean, bean);
		RestResponse response = new BytesRestResponse(RestStatus.OK, BytesRestResponse.TEXT_CONTENT_TYPE,
				outbean.getJsonObj().toJSONString());
		return channel -> {
			try {
				channel.sendResponse(response);
			} catch (final Exception e) {
				channel.sendResponse(new BytesRestResponse(channel, e));
			}
		};
	}

	@Override
	protected void documentation(StringBuilder sb) {
		sb.append("/_cat/xplat/connector\n");
	}

	@Override
	protected Table getTableWithHeader(RestRequest request) {
		final Table table = new Table();
		table.startHeaders();
		table.addCell("xplat", "desc:xplat");
		table.endHeaders();
		return table;
	}
}
