/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.es.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.connector.executor.IBusiManager;
import net.wicp.tams.common.connector.executor.IConfigManager;
import net.wicp.tams.common.connector.executor.busi.ClassLoadManager;
import net.wicp.tams.common.connector.executor.busi.KeyConfigManager;
import net.wicp.tams.common.connector.executor.impl.CommonService;
import net.wicp.tams.common.es.plugin.ConnectorRest;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;

public class TamsRestHandlerPlugin
extends Plugin
implements ActionPlugin {
    public static KeyConfigManager keyConfigManager;
    public static CommonService executor;
    public static URLClassLoader cloasLoader;

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        Logger logger = Loggers.getLogger(TamsRestHandlerPlugin.class, (Settings)settings, (String[])new String[0]);
        logger.info("-------------------begin plugin------------------------------------");
        Properties props = IOUtil.fileToProperties((String)"/plugin-default.properties", TamsRestHandlerPlugin.class);
        Conf.overProp((Properties)props);
        logger.info("-----size:{}", (Object)Conf.copyProperties().size());
        logger.info("path={},packagebase={}", (Object)Conf.get((String)"common.es.plugin.path"), (Object)Conf.get((String)"common.es.plugin.packagebase"));
        executor = new CommonService();
        String path = Conf.get((String)"common.es.plugin.path");
        path = StringUtil.isNull((Object)path) || "none".equals(path) ? IOUtil.mergeFolderAndFilePath((String)IOUtil.getCurFolder(TamsRestHandlerPlugin.class).getParent(), (String[])new String[]{"/plugin"}) : path;
        File pluginDir = new File(path);
        if (!pluginDir.exists()) {
            try {
                FileUtils.forceMkdir((File)pluginDir);
            }
            catch (IOException e) {
                logger.error("\u521b\u5efa\u63d2\u4ef6\u76ee\u5f55:" + path + "\u5931\u8d25", (Throwable)e);
            }
        }
        String[] packages = Conf.get((String)"common.es.plugin.packagebase").split(",");
        ClassLoadManager classLoadManager = new ClassLoadManager(path, 2, packages);
        cloasLoader = classLoadManager.getCloasLoader();
        keyConfigManager = new KeyConfigManager((ClassLoader)cloasLoader);
        executor.setBusiManager((IBusiManager)classLoadManager);
        executor.setConfigManager((IConfigManager)keyConfigManager);
        logger.info("-------------------------xplat plugins start sucess------------------------------");
        return Arrays.asList(new RestHandler[]{new ConnectorRest(settings, restController)});
    }
}

