/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.es.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.constant.RestMethod;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.es.EsAssit;
import net.wicp.tams.common.es.EsData;
import net.wicp.tams.common.es.MappingEnumSerializer;
import net.wicp.tams.common.es.bean.AliasesBean;
import net.wicp.tams.common.es.bean.IndexBean;
import net.wicp.tams.common.es.bean.IndexParamsBean;
import net.wicp.tams.common.es.bean.IndexParamsNoJoin;
import net.wicp.tams.common.es.bean.MappingBean;
import net.wicp.tams.common.es.bean.QueryDataMap;
import net.wicp.tams.common.es.bean.RuleEsSettingBean;
import net.wicp.tams.common.es.bean.SettingsBean;
import net.wicp.tams.common.es.client.EsClientAssit;
import net.wicp.tams.common.es.constant.ClusterSettings;
import net.wicp.tams.common.es.norm.IQueryData;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.http.HttpResult;
import net.wicp.tams.common.web.PageAssist;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.entity.NStringEntity;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESClient {
    private static final Logger log = LoggerFactory.getLogger(ESClient.class);
    private RestClient restClient;
    private RestHighLevelClient restHighLevelClient;
    private Connection connection;
    private static volatile boolean globleInit;
    private final Map<String, Map<String, MappingBean.DataTypes>> mappingMap = new HashMap<String, Map<String, MappingBean.DataTypes>>();
    private final String mappingMapKeyFormate = "%s";
    private TimeValue timeValue = new TimeValue((long)Integer.parseInt(StringUtil.hasNull((String[])new String[]{Conf.get((String)"common.es.query.timeout"), "5000"})), TimeUnit.MILLISECONDS);

    public ESClient(Properties props, Connection connection, String rulesstr) {
        if (props != null) {
            Conf.overProp((Properties)props);
        }
        this.connection = connection;
        this.init(rulesstr);
    }

    public ESClient() {
        this(null, null, null);
    }

    public ESClient(Connection connection, String rulesstr) {
        this(null, connection, rulesstr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doGlobleInit(ESClient eSClient, String rulesstr) {
        if (rulesstr == null || StringUtil.isNull((Object)rulesstr)) {
            return;
        }
        if (globleInit) return;
        Class<ESClient> clazz = ESClient.class;
        synchronized (ESClient.class) {
            Object[] nojoinindexAry;
            Object[] joinindexAry;
            if (globleInit) return;
            List indexs = IndexParamsNoJoin.buildByConf((String)rulesstr);
            String joinindexStr = StringUtil.trimSpace((String)Conf.get((String)"common.es.auto.create.index_join"));
            Object[] objectArray = joinindexAry = StringUtil.isNull((Object)joinindexStr) ? new String[]{} : joinindexStr.split(",");
            if (ArrayUtils.isNotEmpty((Object[])joinindexAry) && this.connection == null) {
                throw new RuntimeException("\u4e0d\u80fd\u521d\u59cb\u5316\u7d22\u5f15\uff0c\u8bf7\u786e\u4fdd\u4f20\u5165connection");
            }
            for (Object indexNamejoin : joinindexAry) {
                IndexParamsNoJoin findByIndex = IndexParamsNoJoin.findByIndex((List)indexs, (String)indexNamejoin);
                if (findByIndex == null) continue;
                IndexParamsBean indexParamsBean = IndexParamsBean.buildFormat((IndexParamsNoJoin)findByIndex);
                eSClient.queryOrCreateMapping_tc((String)indexNamejoin, this.connection, indexParamsBean);
            }
            String nojoinindexStr = StringUtil.trimSpace((String)Conf.get((String)"common.es.auto.create.index_noJoin"));
            Object[] objectArray2 = nojoinindexAry = StringUtil.isNull((Object)nojoinindexStr) ? new String[]{} : nojoinindexStr.split(",");
            if (ArrayUtils.isNotEmpty((Object[])nojoinindexAry) && this.connection == null) {
                throw new RuntimeException("\u4e0d\u80fd\u521d\u59cb\u5316\u7d22\u5f15\uff0c\u8bf7\u786e\u4fdd\u4f20\u5165connection");
            }
            for (Object indexNameNojoin : nojoinindexAry) {
                IndexParamsNoJoin findByIndex = IndexParamsNoJoin.findByIndex((List)indexs, (String)indexNameNojoin);
                if (findByIndex == null) continue;
                eSClient.queryOrCreateMapping_tc((String)indexNameNojoin, this.connection, findByIndex.getRootRule().getDbOri(), findByIndex.getRootRule().getTbOri(), findByIndex.getColBeans().toArray(new RuleEsSettingBean[findByIndex.getColBeans().size()]));
            }
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                log.error("", (Throwable)e);
            }
            globleInit = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private ESClient init(String rulesstr) {
        String hoststrs = Conf.get((String)"common.es.host.name");
        String[] hostary = hoststrs.split(",");
        HttpHost[] httpHosts = new HttpHost[hostary.length];
        for (int i = 0; i < httpHosts.length; ++i) {
            httpHosts[i] = new HttpHost(hostary[i], Integer.parseInt(Conf.get((String)"common.es.host.port.rest")), Conf.get((String)"common.es.host.scheme"));
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts);
        if (StringUtil.isNotNull((Object)Conf.get((String)"common.es.http.head"))) {
            String[] eles = Conf.get((String)"common.es.http.head").split("&", 0);
            Header[] defaultHeaders = new Header[eles.length];
            for (int i = 0; i < defaultHeaders.length; ++i) {
                String[] split = eles[i].split("=");
                defaultHeaders[i] = new BasicHeader(split[0], split[1]);
            }
            builder.setDefaultHeaders(defaultHeaders);
        }
        builder.setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

            public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                requestConfigBuilder.setConnectTimeout(Integer.parseInt(Conf.get((String)"common.es.http.connectTimeout")));
                requestConfigBuilder.setSocketTimeout(Integer.parseInt(Conf.get((String)"common.es.http.socketTimeout")));
                requestConfigBuilder.setConnectionRequestTimeout(Integer.parseInt(Conf.get((String)"common.es.http.connectionRequestTimeout")));
                return requestConfigBuilder;
            }
        });
        builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                httpClientBuilder.setMaxConnTotal(Integer.parseInt(Conf.get((String)"common.es.http.aync.maxConnTotal")));
                httpClientBuilder.setMaxConnPerRoute(Integer.parseInt(Conf.get((String)"common.es.http.aync.maxConnPerRoute")));
                String userName = Conf.get((String)"common.es.cluster.userName");
                String password = Conf.get((String)"common.es.cluster.password");
                if (StringUtil.isNotNull((Object)userName) && StringUtil.isNotNull((Object)password)) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, password));
                    httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
                return httpClientBuilder;
            }
        });
        this.restHighLevelClient = new RestHighLevelClient(builder);
        this.restClient = this.restHighLevelClient.getLowLevelClient();
        System.setProperty("es.set.netty.runtime.available.processors", "false");
        try {
            Settings.Builder settingsBuilder = Settings.builder();
            settingsBuilder.put("client.transport.sniff", true);
            String custerName = StringUtil.hasNull((String[])new String[]{Conf.get((String)"common.es.cluster.name"), "elasticsearch"});
            settingsBuilder.put("cluster.name", custerName);
            Map pres = Conf.getPre((String)"common.es.client", (boolean)true);
            for (String clientkey : pres.keySet()) {
                settingsBuilder.put("client." + clientkey, (String)pres.get(clientkey));
            }
            TransportAddress[] addrs = new TransportAddress[hostary.length];
            for (int i = 0; i < addrs.length; ++i) {
                addrs[i] = new TransportAddress(InetAddress.getByName(hostary[i]), Integer.parseInt(Conf.get((String)"common.es.host.port.transport")));
            }
        }
        catch (UnknownHostException e) {
            log.error("\u521b\u5efaclient\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u521b\u5efaclient\u5931\u8d25", e);
        }
        log.info("\u521b\u5efaESClient\u6210\u529f");
        this.doGlobleInit(this, rulesstr);
        return this;
    }

    public ClusterUpdateSettingsResponse admin_ClusterSettings(Map<ClusterSettings, String> settingmap) {
        ClusterUpdateSettingsRequest request = new ClusterUpdateSettingsRequest();
        Settings.Builder builderTransient = Settings.builder();
        Settings.Builder builderPersistent = Settings.builder();
        for (ClusterSettings set : settingmap.keySet()) {
            set.valid(settingmap.get(set));
            if (set.getType() == ClusterSettings.Type.PERSISTENT) {
                builderPersistent.put(set.getKey(), settingmap.get(set));
            }
            if (set.getType() != ClusterSettings.Type.TRANSIENT) continue;
            builderTransient.put(set.getKey(), settingmap.get(set));
        }
        if (CollectionUtils.isNotEmpty((Collection)builderTransient.keys())) {
            request.transientSettings(builderTransient.build());
        }
        if (CollectionUtils.isNotEmpty((Collection)builderPersistent.keys())) {
            request.persistentSettings(builderPersistent.build());
        }
        try {
            return this.getRestHighLevelClient().cluster().putSettings(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u7fa4\u96c6\u914d\u7f6e\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u66f4\u65b0\u7fa4\u96c6\u914d\u7f6e\u9519\u8bef");
        }
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public RestHighLevelClient getRestHighLevelClient() {
        return this.restHighLevelClient;
    }

    public void close() {
        if (this.restClient != null) {
            try {
                this.restClient.close();
                this.restHighLevelClient.close();
            }
            catch (IOException e) {
                log.error("\u5173\u95edES\u94fe\u63a5\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public <T> Result docWriteBatch(String index, String idColName, List<T> insertList) {
        BulkRequest bulkRequest = new BulkRequest();
        for (T insertObj : insertList) {
            IndexRequest indexRequest = new IndexRequest(index);
            if (StringUtil.isNotNull((Object)idColName)) {
                try {
                    Object property = PropertyUtils.getProperty(insertObj, (String)idColName);
                    indexRequest.id(String.valueOf(property));
                }
                catch (Exception e) {
                    return Result.getError((String)e.getMessage());
                }
            }
            indexRequest.source(JSON.toJSONString(insertObj), XContentType.JSON);
            bulkRequest.add(indexRequest);
        }
        try {
            this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            return Result.getSuc();
        }
        catch (IOException e) {
            log.error("\u6279\u91cf\u6dfb\u52a0\u6587\u6863\u9519\u8bef", (Throwable)e);
            return Result.getError((String)("\u6279\u91cf\u6dfb\u52a0\u6587\u6863\u9519\u8bef" + e.getMessage()));
        }
    }

    public Result docWriteBatch(List<EsData> esDatas) {
        BulkRequest bulkRequest = new BulkRequest();
        for (EsData esData : esDatas) {
            Map<String, MappingBean.DataTypes> mapping = this.queryMapping_tc(esData.getIndex());
            bulkRequest.add(EsAssit.packRequest((EsData)esData, mapping));
        }
        try {
            BulkResponse bulk = this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulk.hasFailures()) {
                Result error = new Result((IExcept)ExceptAll.project_haveerrors);
                error.setRetObjs((Object[])bulk.getItems());
                return error;
            }
            return Result.getSuc();
        }
        catch (IOException e) {
            log.error("\u6279\u91cf\u6dfb\u52a0\u6587\u6863\u9519\u8bef", (Throwable)e);
            return Result.getError((String)("\u6279\u91cf\u6dfb\u52a0\u6587\u6863\u9519\u8bef" + e.getMessage()));
        }
    }

    public Result docWriteBatch_tc(List<EsData> esDatas, Map<String, MappingBean.DataTypes> mappingParam) {
        BulkRequest bulkRequest = new BulkRequest();
        for (EsData esData : esDatas) {
            String key = String.format("%s", esData.getIndex());
            Map<String, MappingBean.DataTypes> mappingtrue = mappingParam;
            if (mappingtrue == null) {
                if (this.mappingMap.get(key) == null) {
                    mappingtrue = this.queryMapping_tc(esData.getIndex());
                    this.mappingMap.put(key, mappingtrue);
                } else {
                    mappingtrue = this.mappingMap.get(key);
                }
            }
            bulkRequest.add(EsAssit.packRequest((EsData)esData, mappingtrue));
        }
        if (bulkRequest.numberOfActions() == 0) {
            log.error("\u51fa\u73b0\u6570\u636e\u88ab\u8fc7\u6ee4");
            return Result.getSuc();
        }
        try {
            BulkResponse bulk = this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulk.hasFailures()) {
                Object[] items = bulk.getItems();
                if (ArrayUtils.isEmpty((Object[])items)) {
                    return Result.getSuc();
                }
                for (int i = items.length - 1; i >= 0; --i) {
                    if (items[i] != null && StringUtil.isNotNull((Object)items[i].getFailureMessage()) && items[i].getFailureMessage().contains("version_conflict_engine_exception")) {
                        log.warn("===version=====" + items[i].getFailureMessage());
                        items = (BulkItemResponse[])ArrayUtils.remove((Object[])items, (int)i);
                        continue;
                    }
                    log.error("===Failure=====" + items[i].getFailure());
                    log.error("===FailureMessage=====" + items[i].getFailureMessage());
                }
                if (ArrayUtils.isNotEmpty((Object[])items)) {
                    Result error = new Result((IExcept)ExceptAll.project_haveerrors);
                    error.setRetObjs((Object[])bulk.getItems());
                    return error;
                }
                return Result.getSuc();
            }
            return Result.getSuc();
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u6dfb\u52a0\u6587\u6863\u9519\u8bef", (Throwable)e);
            return Result.getError((String)("\u6279\u91cf\u6dfb\u52a0\u6587\u6863\u9519\u8bef" + e.getMessage()));
        }
    }

    public Result indexRefresh(String ... indexName) {
        Result ret = Result.getSuc();
        try {
            RefreshResponse response = this.getIndices().refresh(new RefreshRequest(indexName), RequestOptions.DEFAULT);
            if (response.getShardFailures().length == response.getTotalShards()) {
                log.error("ES\u7d22\u5f15\u5237\u65b0\u5931\u8d25" + response.getShardFailures());
                ret = Result.getError((String)("ES\u7d22\u5f15\u5237\u65b0\u5931\u8d25" + response.getShardFailures()));
            } else if (response.getShardFailures().length > 0) {
                log.error("ES\u7d22\u5f15\u5237\u65b0\u90e8\u5206\u5206\u7247\u5931\u8d25" + response.getShardFailures());
                ret = Result.getError((String)("ES\u7d22\u5f15\u5237\u65b0\u90e8\u5206\u5206\u7247\u5931\u8d25" + response.getShardFailures()));
            }
        }
        catch (Exception e) {
            log.error("ES\u5237\u65b0\u5931\u8d25", (Throwable)e);
            ret = new Result((IExcept)ExceptAll.duckula_es_refresh);
        }
        return ret;
    }

    private IndicesClient getIndices() {
        return this.restHighLevelClient.indices();
    }

    public Result indexFlush(String ... indexName) {
        Result ret = Result.getSuc();
        try {
            FlushResponse response = this.getIndices().flush(new FlushRequest(indexName), RequestOptions.DEFAULT);
            if (response.getShardFailures().length == response.getTotalShards()) {
                log.error("ES\u7d22\u5f15\u5237\u65b0\u5931\u8d25" + response.getShardFailures());
                ret = Result.getError((String)("ES\u7d22\u5f15\u5237\u65b0\u5931\u8d25" + response.getShardFailures()));
            } else if (response.getShardFailures().length > 0) {
                log.error("ES\u7d22\u5f15\u5237\u65b0\u90e8\u5206\u5206\u7247\u5931\u8d25" + response.getShardFailures());
                ret = Result.getError((String)("ES\u7d22\u5f15\u5237\u65b0\u90e8\u5206\u5206\u7247\u5931\u8d25" + response.getShardFailures()));
            }
        }
        catch (Exception e) {
            log.error("ES\u5237\u65b0\u5931\u8d25", (Throwable)e);
            ret = new Result((IExcept)ExceptAll.duckula_es_flush);
        }
        return ret;
    }

    public void cleanMappingMap() {
        this.mappingMap.clear();
    }

    public Result docWriteBatch_tc(Map<String, MappingBean.DataTypes> mappingParam, EsData ... esDatas) {
        return this.docWriteBatch_tc(Arrays.asList(esDatas), mappingParam);
    }

    public Result docWriteBatch_tc(EsData ... esDatas) {
        return this.docWriteBatch_tc(Arrays.asList(esDatas), null);
    }

    public Result indexCreate(String indexName, int shardsNum, int replicas, String alias, MappingBean mappingBean) {
        Validate.notEmpty((CharSequence)indexName);
        Validate.isTrue((shardsNum > 0 ? 1 : 0) != 0);
        Validate.isTrue((replicas >= 0 ? 1 : 0) != 0);
        Validate.notNull((Object)mappingBean);
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        request.settings(Settings.builder().put("index.number_of_shards", shardsNum).put("index.number_of_replicas", replicas));
        String jsonString2 = this.mappingFormat(mappingBean);
        request.mapping(jsonString2, XContentType.JSON);
        if (StringUtil.isNotNull((Object)alias)) {
            request.alias(new Alias(alias));
        }
        try {
            CreateIndexResponse createIndexResponse = this.getIndices().create(request, RequestOptions.DEFAULT);
            return Result.getSuc();
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return Result.getError((String)("\u521b\u5efa\u7d22\u5f15\u5931\u8d25:" + e.getMessage()));
        }
        catch (ElasticsearchStatusException e) {
            log.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return Result.getError((String)("\u521b\u5efa\u7d22\u5f15\u5931\u8d25:" + e.getDetailedMessage()));
        }
    }

    public Result indexCreate(String indexName, int shardsNum, int replicas, MappingBean mappingBean) {
        return this.indexCreate(indexName, shardsNum, replicas, null, mappingBean);
    }

    public Result indexCreate(String indexName, int shardsNum, MappingBean mappingBean) {
        return this.indexCreate(indexName, shardsNum, 0, null, mappingBean);
    }

    public Result indexCreate(Connection conn, IndexParamsBean mapping, String indexName, int shardsNum, int replicas) {
        MappingBean proMappingBean = EsAssit.proMappingBean((Connection)conn, (IndexParamsBean)mapping);
        if (proMappingBean == null) {
            return Result.getError((String)"\u5f97\u5230MappingBean\u5931\u8d25");
        }
        return this.indexCreate(indexName, shardsNum, 0, null, proMappingBean);
    }

    public Result indexCreate(Connection conn, String db, String tb, String indexName, int shardsNum, int replicas, RuleEsSettingBean ... indexParamsNoJoinBeans) {
        MappingBean proMappingBean = EsAssit.proMappingBean((Connection)conn, (String)db, (String)tb, (RuleEsSettingBean[])indexParamsNoJoinBeans);
        if (proMappingBean == null) {
            return Result.getError((String)"\u5f97\u5230MappingBean\u5931\u8d25");
        }
        return this.indexCreate(indexName, shardsNum, 0, null, proMappingBean);
    }

    public Result aliasCreate(String indexNamePatten, String ... aliass) {
        JSONArray actions = new JSONArray();
        for (String alias : aliass) {
            actions.add((Object)JSON.parseObject((String)(" { \"add\" : { \"index\" : \"" + indexNamePatten + "\", \"alias\" : \"" + alias + "\" } }")));
        }
        JSONObject params = JSONUtil.packParams((Object[])new Object[]{"actions", actions});
        HttpResult callRest = this.callRest(RestMethod.POST, "/_aliases", params);
        return callRest.getResult();
    }

    public Result indexReplace(String indexNew, String indexOld, boolean idDelOld, String ... aliass) {
        JSONArray actions = new JSONArray();
        for (String alias : aliass) {
            actions.add((Object)JSON.parseObject((String)(" { \"add\" : { \"index\" : \"" + indexNew + "\", \"alias\" : \"" + alias + "\" } }")));
            if (idDelOld) {
                actions.add((Object)JSON.parseObject((String)(" { \"remove_index\": { \"index\": \"" + indexOld + "\" } }")));
                continue;
            }
            actions.add((Object)JSON.parseObject((String)(" { \"remove\" : { \"index\" : \"" + indexOld + "\", \"alias\" : \"" + alias + "\" } }")));
        }
        JSONObject params = JSONUtil.packParams((Object[])new Object[]{"actions", actions});
        HttpResult callRest = this.callRest(RestMethod.POST, "/_aliases", params);
        return callRest.getResult();
    }

    public Result indexDel(String index) {
        JSONArray actions = new JSONArray();
        actions.add((Object)JSON.parseObject((String)(" { \"remove_index\": { \"index\": \"" + index + "\" } }")));
        JSONObject params = JSONUtil.packParams((Object[])new Object[]{"actions", actions});
        HttpResult callRest = this.callRest(RestMethod.POST, "/_aliases", params);
        return callRest.getResult();
    }

    public Result indexSetting(String index, SettingsBean settingsBean) {
        JSONObject obj = JSON.parseObject((String)JSONObject.toJSONString((Object)settingsBean));
        Validate.isTrue((obj.size() > 0 ? 1 : 0) != 0, (String)"\u526f\u672c\u6570\u4e0e\u5237\u65b0\u95f4\u9694\u5fc5\u987b\u586b\u4e00\u4e2a", (Object[])new Object[0]);
        if (SettingsBean.fresh_null.equals(settingsBean.getRefresh_interval())) {
            obj.put("refresh_interval", null);
        }
        String jsonString = JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        String point = String.format("/%s/_settings", index);
        HttpResult callRest = this.callRest(RestMethod.PUT, point, String.format("{\"index\" : %s}", jsonString));
        return callRest.getResult();
    }

    public HttpResult callRest(RestMethod restMethod, String point, JSONObject params) {
        return this.callRest(restMethod, point, params.toJSONString());
    }

    public HttpResult callRest(RestMethod restMethod, String point, String paramsStr) {
        NStringEntity entity = null;
        if (StringUtil.isNotNull((Object)paramsStr)) {
            entity = new NStringEntity(paramsStr, ContentType.APPLICATION_JSON);
        }
        try {
            Request request = new Request(restMethod.name(), point);
            request.setEntity((HttpEntity)entity);
            Response response = this.restClient.performRequest(request);
            HttpResult httpResult = EsClientAssit.packHttpResult(response);
            return httpResult;
        }
        catch (IOException e) {
            log.error("rest\u5f62\u5f0f\u8c03\u7528\u5931\u8d25", (Throwable)e);
            HttpResult ret = new HttpResult();
            ret.setErrMsg(e.getMessage());
            return ret;
        }
    }

    public HttpResult callRest(RestMethod restMethod, String point) {
        return this.callRest(restMethod, point, "");
    }

    private String mappingFormat(MappingBean mappingBean) {
        SerializeConfig tamsSerializeConfig = SerializeConfig.getGlobalInstance();
        tamsSerializeConfig.put(MappingBean.DataTypes.class, (ObjectSerializer)MappingEnumSerializer.instance);
        tamsSerializeConfig.put(MappingBean.Dynamic.class, (ObjectSerializer)MappingEnumSerializer.instance);
        String jsonString = JSON.toJSONString((Object)mappingBean, (SerializeConfig)tamsSerializeConfig, (SerializerFeature[])new SerializerFeature[0]);
        String jsonString2 = JSON.toJSONString((Object)JSON.parse((String)jsonString), (boolean)true);
        return jsonString2;
    }

    public Result docWrite(String index, Object data) {
        IndexRequest indexRequest = new IndexRequest(index);
        indexRequest.source(JSON.toJSONString((Object)data), XContentType.JSON);
        try {
            this.restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
            return Result.getSuc();
        }
        catch (IOException e) {
            log.error("\u6dfb\u52a0\u6587\u6863\u9519\u8bef", (Throwable)e);
            return Result.getError((String)("\u6dfb\u52a0\u6587\u6863\u9519\u8bef" + e.getMessage()));
        }
    }

    public <T> Result docUpdate(String index, String id, T updateObj) {
        UpdateRequest updateRequest = new UpdateRequest(index, id);
        updateRequest.doc(JSON.toJSONString(updateObj), XContentType.JSON);
        try {
            this.restHighLevelClient.update(updateRequest, RequestOptions.DEFAULT);
            return Result.getSuc();
        }
        catch (IOException e) {
            log.error("\u66f4\u65b0\u6587\u6863\u9519\u8bef", (Throwable)e);
            return Result.getError((String)("\u66f4\u65b0\u6587\u6863\u9519\u8bef" + e.getMessage()));
        }
    }

    public Result docDel(String index, String id) {
        DeleteRequest deleteRequest = new DeleteRequest(index, id);
        try {
            this.restHighLevelClient.delete(deleteRequest, RequestOptions.DEFAULT);
            return Result.getSuc();
        }
        catch (IOException e) {
            log.error("\u5220\u9664\u6587\u6863\u9519\u8bef", (Throwable)e);
            return Result.getError((String)("\u5220\u9664\u6587\u6863\u9519\u8bef" + e.getMessage()));
        }
    }

    public void docDelBatchQuery(String index, String key, String value) {
        try {
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.timeout(new TimeValue(2L, TimeUnit.SECONDS));
            TermQueryBuilder termQueryBuilder1 = QueryBuilders.termQuery((String)key, (String)value);
            sourceBuilder.query((QueryBuilder)termQueryBuilder1);
            SearchRequest searchRequest = new SearchRequest(new String[]{index});
            searchRequest.source(sourceBuilder);
            SearchResponse response = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            ArrayList<String> docIds = new ArrayList<String>(hits.getHits().length);
            for (SearchHit hit : hits) {
                docIds.add(hit.getId());
            }
            BulkRequest bulkRequest = new BulkRequest();
            for (String id : docIds) {
                DeleteRequest deleteRequest = new DeleteRequest(index, id);
                bulkRequest.add(deleteRequest);
            }
            this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            log.error("\u6279\u91cf\u5220\u9664\u6587\u6863\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u6279\u91cf\u5220\u9664\u6587\u6863\u9519\u8bef", e);
        }
    }

    public List<IndexBean> queryIndex(String indexPattern) {
        String cmd = StringUtil.isNull((Object)indexPattern) ? "_cat/indices?v" : "_cat/indices/" + indexPattern + "?v&s=index";
        List<IndexBean> retlist = this.callCat(IndexBean.class, cmd);
        return retlist;
    }

    public List<AliasesBean> queryAliases(String aliasesPattern) {
        String cmd = StringUtil.isNull((Object)aliasesPattern) ? "_cat/aliases?v" : "_cat/aliases/" + aliasesPattern + "?v";
        List<AliasesBean> retlist = this.callCat(AliasesBean.class, cmd);
        return retlist;
    }

    public <T> List<T> callCat(Class<T> calssz, String cmd) {
        ArrayList<Object> retlist = new ArrayList<Object>();
        HttpResult httpResult = this.callRest(RestMethod.GET, cmd, "");
        if (!httpResult.getResult().isSuc()) {
            return retlist;
        }
        String bodyStr = httpResult.getBodyStr();
        String[] rows = bodyStr.split("\n");
        String[] head = rows[0].split("[\\s]+");
        for (int i = 1; i < rows.length; ++i) {
            String[] cols = rows[i].split("[\\s]+");
            JSONObject json = new JSONObject();
            for (int j = 0; j < cols.length; ++j) {
                json.put(head[j].replaceAll("\\.", "_"), (Object)cols[j]);
            }
            retlist.add(json.toJavaObject(calssz));
        }
        return retlist;
    }

    public GetIndexResponse queryIndex_tc(String indexName, String ... types) {
        GetIndexRequest query = new GetIndexRequest();
        query.indices(new String[]{indexName});
        if (ArrayUtils.isNotEmpty((Object[])types)) {
            query.types(types);
        }
        IndicesClient indicesClient = this.restHighLevelClient.indices();
        try {
            GetIndexResponse resp = indicesClient.get(query, RequestOptions.DEFAULT);
            return resp;
        }
        catch (Exception e) {
            log.error("\u67e5\u627e\u7d22\u5f15\u5931\u8d25,\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new RuntimeException("\u67e5\u627e\u7d22\u5f15\u5931\u8d25", e);
        }
    }

    public Map<String, MappingBean.DataTypes> queryMapping_tc(String indexName) {
        GetIndexResponse queryIndex_tc = this.queryIndex_tc(indexName, new String[0]);
        Iterator iterator = ((ImmutableOpenMap)queryIndex_tc.getMappings().get((Object)indexName)).iterator();
        HashMap<String, MappingBean.DataTypes> retmap = new HashMap<String, MappingBean.DataTypes>();
        if (iterator.hasNext()) {
            ObjectObjectCursor next = (ObjectObjectCursor)iterator.next();
            LinkedHashMap object = (LinkedHashMap)((MappingMetaData)next.value).sourceAsMap().get("properties");
            for (String key : object.keySet()) {
                String typestr = (String)((LinkedHashMap)object.get(key)).get("type");
                retmap.put(key, MappingBean.DataTypes.getDataTypeByName((String)typestr));
            }
        }
        return retmap;
    }

    public Map<String, Pair<MappingBean.DataTypes, MappingBean.DataTypes>> queryDiffMapping_tc(String indexName, List<Pair<String, String>> dbcolInfos, boolean needDel) {
        if (StringUtil.isNull((Object)indexName) || CollectionUtils.isEmpty(dbcolInfos)) {
            return null;
        }
        HashMap<String, Pair<MappingBean.DataTypes, MappingBean.DataTypes>> ret = new HashMap<String, Pair<MappingBean.DataTypes, MappingBean.DataTypes>>();
        Map<String, MappingBean.DataTypes> indexMap = this.queryMapping_tc(indexName);
        for (Pair<String, String> dbcolInfo : dbcolInfos) {
            String colNameTrue;
            MappingBean.DataTypes dbtypes = MappingBean.DataTypes.getDataTypesByMysqlType((BinlogType)BinlogType.getByName((String)((String)dbcolInfo.getRight())));
            String string = colNameTrue = Conf.getBoolean((String)"common.es.assit.colname.convert") != false ? StringUtil.convertStr((String)((String)dbcolInfo.getLeft())) : (String)dbcolInfo.getLeft();
            if (indexMap.containsKey(colNameTrue)) {
                if (dbtypes == indexMap.get(colNameTrue)) continue;
                ret.put((String)dbcolInfo.getLeft(), (Pair<MappingBean.DataTypes, MappingBean.DataTypes>)Pair.of((Object)dbtypes, (Object)indexMap.get(dbcolInfo.getLeft())));
                continue;
            }
            ret.put((String)dbcolInfo.getLeft(), (Pair<MappingBean.DataTypes, MappingBean.DataTypes>)Pair.of((Object)dbtypes, null));
        }
        if (needDel) {
            for (String colName : indexMap.keySet()) {
                boolean has = false;
                for (Pair<String, String> dbcolInfo : dbcolInfos) {
                    String colNameTrue = Conf.getBoolean((String)"common.es.assit.colname.convert") != false ? StringUtil.convertStr((String)((String)dbcolInfo.getLeft())) : (String)dbcolInfo.getLeft();
                    if (!colName.equals(colNameTrue)) continue;
                    has = true;
                    break;
                }
                if (has) continue;
                ret.put(colName, (Pair<MappingBean.DataTypes, MappingBean.DataTypes>)Pair.of(null, (Object)indexMap.get(colName)));
            }
        }
        return ret;
    }

    public MappingBean proMappingBean(Map<String, Pair<MappingBean.DataTypes, MappingBean.DataTypes>> params) {
        JSONObject retjson = new JSONObject();
        for (String colName : params.keySet()) {
            Pair<MappingBean.DataTypes, MappingBean.DataTypes> deffValue = params.get(colName);
            if (deffValue.getLeft() != null && deffValue.getRight() != null || deffValue.getLeft() == null || deffValue.getRight() != null) continue;
            retjson.put(colName, (Object)((MappingBean.DataTypes)deffValue.getLeft()).name());
        }
        MappingBean proMappingBean = MappingBean.proMappingBean((String)retjson.toJSONString());
        return proMappingBean;
    }

    public Map<String, MappingBean.DataTypes> queryOrCreateMapping_tc(String indexName, Connection conn, IndexParamsBean indexParamsBean) {
        Map<String, MappingBean.DataTypes> tempmap;
        block2: {
            tempmap = null;
            try {
                tempmap = this.queryMapping_tc(indexName);
            }
            catch (Throwable t) {
                Result indexCreate = this.indexCreate(conn, indexParamsBean, indexName, indexParamsBean.getShardsNum(), 0);
                if (!indexCreate.isSuc()) break block2;
                tempmap = this.queryMapping_tc(indexName);
            }
        }
        return tempmap;
    }

    public Map<String, MappingBean.DataTypes> queryOrCreateMapping_tc(String indexName, Connection conn, String db, String tb, RuleEsSettingBean ... indexParamsNoJoinBeans) {
        Map<String, MappingBean.DataTypes> tempmap;
        block2: {
            tempmap = null;
            try {
                tempmap = this.queryMapping_tc(indexName);
            }
            catch (Throwable t) {
                Result indexCreate = this.indexCreate(conn, db, tb, indexName, 15, 0, indexParamsNoJoinBeans);
                if (!indexCreate.isSuc()) break block2;
                tempmap = this.queryMapping_tc(indexName);
            }
        }
        return tempmap;
    }

    public Map<String, MappingBean.Propertie> queryMapping_tc_all(String indexName) {
        GetIndexResponse queryIndex_tc = this.queryIndex_tc(indexName, new String[0]);
        Iterator iterator = ((ImmutableOpenMap)queryIndex_tc.getMappings().get((Object)indexName)).iterator();
        HashMap<String, MappingBean.Propertie> retmap = new HashMap<String, MappingBean.Propertie>();
        if (iterator.hasNext()) {
            ObjectObjectCursor next = (ObjectObjectCursor)iterator.next();
            LinkedHashMap object = (LinkedHashMap)((MappingMetaData)next.value).sourceAsMap().get("properties");
            for (String key : object.keySet()) {
                MappingBean.Propertie props = new MappingBean.Propertie();
                String typestr = (String)((LinkedHashMap)object.get(key)).get("type");
                props.setType(MappingBean.DataTypes.getDataTypeByName((String)typestr));
                if (key.equals(Conf.get((String)"common.es.assit.rela.key"))) {
                    String jsonForMap = JSONUtil.getJsonForMap((Map)((Map)object.get(key)));
                    props.setRelations(JSONObject.parseObject((String)jsonForMap).getJSONObject("relations"));
                }
                retmap.put(key, props);
            }
        }
        return retmap;
    }

    public <T extends IQueryData> List<T> queryDocPage(Class<T> classz, PageAssist pageAssist, QueryBuilder queryBuilder, String index) {
        Validate.isTrue((StringUtil.isNotNull((Object)(index = StringUtil.hasNull((String[])new String[]{index, Conf.get((String)"common.es.query.index")}))) && !"none".equals(index) ? 1 : 0) != 0, (String)"\u9700\u8981\u6307\u5b9a\u7d22\u5f15", (Object[])new Object[0]);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.timeout(this.timeValue);
        sourceBuilder.query(queryBuilder);
        sourceBuilder.from(pageAssist.getFrom());
        sourceBuilder.size(pageAssist.getPageSize());
        if (StringUtil.isNotNull((Object)pageAssist.getSortField())) {
            sourceBuilder.sort(pageAssist.getSortField(), pageAssist.getSortDesc() == YesOrNo.yes ? SortOrder.DESC : SortOrder.ASC);
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        searchRequest.source(sourceBuilder);
        SearchResponse response = null;
        try {
            response = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.duckula_es_query);
        }
        SearchHits hits = response.getHits();
        ArrayList<IQueryData> retlist = new ArrayList<IQueryData>();
        for (SearchHit searchHit : hits) {
            System.out.println("searchHit----" + searchHit.getId());
            IQueryData parseObject = null;
            if ("net.wicp.tams.common.es.bean.QueryDataMap".equals(classz.getName())) {
                QueryDataMap queryDataMap = new QueryDataMap();
                queryDataMap.setData(searchHit.getSourceAsMap());
                parseObject = queryDataMap;
            } else {
                parseObject = (IQueryData)JSONObject.parseObject((String)searchHit.getSourceAsString(), classz);
            }
            IQueryData querydata = parseObject;
            querydata.set_id(searchHit.getId());
            querydata.set_index(searchHit.getIndex());
            querydata.set_type(searchHit.getType());
            retlist.add(parseObject);
        }
        pageAssist.setResult(retlist);
        return retlist;
    }

    public <T extends IQueryData> List<T> queryDocPage(Class<T> classz, PageAssist pageAssist, QueryBuilder queryBuilder) {
        return this.queryDocPage(classz, pageAssist, queryBuilder, null);
    }

    public Result updateIndex(String indexName, MappingBean mappingBean) {
        Validate.notEmpty((CharSequence)indexName);
        Validate.notNull((Object)mappingBean);
        if (MapUtils.isEmpty((Map)mappingBean.getProperties())) {
            return Result.getSuc();
        }
        String jsonString2 = this.mappingFormat(mappingBean);
        PutMappingRequest request = new PutMappingRequest(new String[]{indexName});
        request.source(jsonString2, XContentType.JSON);
        try {
            this.getIndices().putMapping(request, RequestOptions.DEFAULT);
            this.mappingMap.remove(indexName);
            return Result.getSuc();
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return Result.getError((String)("\u521b\u5efa\u7d22\u5f15\u5931\u8d25:" + e.getMessage()));
        }
        catch (ElasticsearchStatusException e) {
            log.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return Result.getError((String)("\u521b\u5efa\u7d22\u5f15\u5931\u8d25:" + e.getDetailedMessage()));
        }
    }

    static {
        Conf.overConf((String)"/common-es-assit.properties", EsAssit.class, (boolean)false);
        Conf.overConf((String)"/common-es-client.properties", EsClientAssit.class, (boolean)false);
        globleInit = false;
    }
}

