package net.wicp.tams.common.es.client.threadlocal;

import java.sql.Connection;

import net.wicp.tams.common.es.client.ESClient;
import net.wicp.tams.common.thread.threadlocal.ObjectCreator;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

public class EsClientThreadlocal implements ObjectCreator<ESClient> {

	private static final String perVarEsClient = "perVarEsClient";
	private Connection conn;
	private String rulesstr;

	private EsClientThreadlocal(Connection conn,String rulesstr) {
		this.conn = conn;
		this.rulesstr=rulesstr;
	}

	private EsClientThreadlocal() {
		this(null,null);
	}

	@Override
	public ESClient createObject() {
		ESClient retobj = new ESClient(this.conn,this.rulesstr);
		return retobj;
	}

	public static ESClient createPerThreadEsClient(Connection conn,String rulesstr) {
		ObjectCreator<ESClient> creator = PerthreadManager.getInstance().createValue(perVarEsClient,
				new EsClientThreadlocal(conn,rulesstr));
		return creator.createObject();
	}

	public static ESClient createPerThreadEsClient() {
		return createPerThreadEsClient(null,null);
	}

}
