package net.wicp.tams.common.es.client.singleton;

import java.sql.Connection;

import net.wicp.tams.common.es.client.ESClient;

public class ESClientOnlyOne {
	private volatile static ESClientOnlyOne eSClientOnlyOne;
	private final ESClient eSClient;
	private final String rulesstr;

	public String getRulesstr() {
		return rulesstr;
	}

	private ESClientOnlyOne(Connection conn,String rulesstr) {
		this.eSClient = new ESClient(conn,rulesstr);
		this.rulesstr=rulesstr;
	}

	private ESClientOnlyOne() {
		this(null,null);
	}

	public static ESClientOnlyOne getInst(Connection conn,String rulesstr) {
		if (eSClientOnlyOne == null) {
			synchronized (ESClientOnlyOne.class) {
				if (eSClientOnlyOne == null) {
					eSClientOnlyOne = new ESClientOnlyOne(conn,rulesstr);
				}
			}
		}
		return eSClientOnlyOne;
	}

	public static ESClientOnlyOne getInst() {
		return getInst(null,null);
	}

	public ESClient getESClient() {
		return eSClient;
	}

}
