package net.wicp.tams.common.es.client.singleton;

import java.sql.Connection;

import net.wicp.tams.common.es.client.ESClient;

public class ESClientOnlyOne {
	private volatile static ESClientOnlyOne eSClientOnlyOne;
	private final ESClient eSClient;

	private ESClientOnlyOne(Connection conn) {
		this.eSClient = new ESClient(conn);
	}

	private ESClientOnlyOne() {
		this(null);
	}

	public static ESClientOnlyOne getInst(Connection conn) {
		if (eSClientOnlyOne == null) {
			synchronized (ESClientOnlyOne.class) {
				if (eSClientOnlyOne == null) {
					eSClientOnlyOne = new ESClientOnlyOne(conn);
				}
			}
		}
		return eSClientOnlyOne;
	}

	public static ESClientOnlyOne getInst() {
		return getInst(null);
	}

	public ESClient getESClient() {
		return eSClient;
	}

}
