package net.wicp.tams.common.es.client.threadlocal;

import java.sql.Connection;

import net.wicp.tams.common.es.client.ESClient;
import net.wicp.tams.common.thread.threadlocal.ObjectCreator;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

public class EsClientThreadlocal implements ObjectCreator<ESClient> {

	private static final String perVarEsClient = "perVarEsClient";
	private Connection conn;

	private EsClientThreadlocal(Connection conn) {
		this.conn = conn;
	}

	private EsClientThreadlocal() {
		this(null);
	}

	@Override
	public ESClient createObject() {
		ESClient retobj = new ESClient(this.conn);
		return retobj;
	}

	public static ESClient createPerThreadEsClient(Connection conn) {
		ObjectCreator<ESClient> creator = PerthreadManager.getInstance().createValue(perVarEsClient,
				new EsClientThreadlocal(conn));
		return creator.createObject();
	}

	public static ESClient createPerThreadEsClient() {
		return createPerThreadEsClient(null);
	}

}
