package net.wicp.tams.common.es.client.singleton;

import net.wicp.tams.common.es.client.ESClient;

public class ESClientOnlyOne {
	private static ESClientOnlyOne eSClientOnlyOne;
	private final ESClient eSClient;

	private ESClientOnlyOne() {
		this.eSClient = new ESClient();
	}

	public static ESClientOnlyOne getInst() {
		if (eSClientOnlyOne == null) {
			synchronized (ESClientOnlyOne.class) {
				if (eSClientOnlyOne == null) {
					eSClientOnlyOne = new ESClientOnlyOne();
				}
			}
		}
		return eSClientOnlyOne;
	}

	public ESClient getESClient() {
		return eSClient;
	}

}
