package net.wicp.tams.common.es.client.pool;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

import net.wicp.tams.common.es.client.ESClient;

public class ESClientFactory implements PooledObjectFactory<ESClient> {

	@Override
	public void destroyObject(PooledObject<ESClient> arg0) throws Exception {
		ESClient eSClient = arg0.getObject();
		eSClient.getClient().close();
	}

	@Override
	public PooledObject<ESClient> makeObject() throws Exception {
		ESClient eSClient=new ESClient();
		return new DefaultPooledObject<ESClient>(eSClient);
	}

	@Override
	public void activateObject(PooledObject<ESClient> arg0) throws Exception {
		// 激活初始化

	}

	@Override
	public void passivateObject(PooledObject<ESClient> arg0) throws Exception {
		// 纯化
	}

	@Override
	public boolean validateObject(PooledObject<ESClient> arg0) {
		return true;//TODO
	}

}
