/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.es.bean;

import java.util.ArrayList;
import java.util.List;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleManager;
import net.wicp.tams.common.es.bean.RuleEsSettingBean;

public class IndexParamsNoJoin {
    private final String index;
    private Rule rootRule;
    private final List<RuleEsSettingBean> colBeans = new ArrayList<RuleEsSettingBean>();
    private int shardsNum = 15;

    private IndexParamsNoJoin(Rule rule) {
        this.index = (String)rule.getItems().get(RuleItem.index);
        if (rule.getParent() == null) {
            this.rootRule = rule;
        }
    }

    public void addRuleEsSettingBean(RuleEsSettingBean ruleEsSettingBean) {
        this.colBeans.add(ruleEsSettingBean);
    }

    public static List<IndexParamsNoJoin> buildByConf(String rulesstr) {
        if (StringUtil.isNull((Object)rulesstr)) {
            return null;
        }
        ArrayList<IndexParamsNoJoin> retlist = new ArrayList<IndexParamsNoJoin>();
        RuleManager manager = new RuleManager(rulesstr);
        for (Rule rule : manager.getRules()) {
            IndexParamsNoJoin temp = new IndexParamsNoJoin(rule);
            int indexOf = retlist.indexOf(temp);
            if (indexOf < 0) {
                retlist.add(temp);
            } else {
                temp = (IndexParamsNoJoin)retlist.get(indexOf);
            }
            if (rule.getParent() == null) {
                temp.setRootRule(rule);
                continue;
            }
            String many = StringUtil.trimSpace((String)((String)rule.getItems().get(RuleItem.many)));
            String relakey = StringUtil.trimSpace((String)((String)rule.getItems().get(RuleItem.relakey)));
            RuleEsSettingBean ruleEsSettingBean = new RuleEsSettingBean(rule, relakey, many);
            temp.addRuleEsSettingBean(ruleEsSettingBean);
        }
        return retlist;
    }

    public static IndexParamsNoJoin findByIndex(List<IndexParamsNoJoin> paramslist, String indexName) {
        IndexParamsNoJoin retobj = null;
        for (IndexParamsNoJoin indexParamsNoJoin : paramslist) {
            if (!indexName.equalsIgnoreCase(indexParamsNoJoin.getIndex())) continue;
            retobj = indexParamsNoJoin;
            break;
        }
        return retobj;
    }

    public boolean equals(Object obj) {
        IndexParamsNoJoin temp = (IndexParamsNoJoin)obj;
        return this.getIndex().equals(temp.getIndex());
    }

    public int hashCode() {
        return this.getIndex().hashCode();
    }

    public String getIndex() {
        return this.index;
    }

    public Rule getRootRule() {
        return this.rootRule;
    }

    public List<RuleEsSettingBean> getColBeans() {
        return this.colBeans;
    }

    public int getShardsNum() {
        return this.shardsNum;
    }

    public void setRootRule(Rule rootRule) {
        this.rootRule = rootRule;
    }

    public void setShardsNum(int shardsNum) {
        this.shardsNum = shardsNum;
    }

    public String toString() {
        return "IndexParamsNoJoin(index=" + this.getIndex() + ", rootRule=" + this.getRootRule() + ", colBeans=" + this.getColBeans() + ", shardsNum=" + this.getShardsNum() + ")";
    }
}

