package net.wicp.tams.common.es.bean;

import java.util.Map;

import lombok.Data;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.es.bean.MappingBean.DataTypes;

/***
 * 创建索引用的辅助bean,用于all in one类型
 * 
 * @author andy.zhou
 *
 */

@Data
public class RuleEsSettingBean {
	private static final String format = "%s_%s";
	private final Rule rule;
	private String relakey;
	private boolean tomany = true;
	private Map<String, DataTypes> colToType;// 数据对应的类型，如果是自动建索引时拿不到对应的表，是不能得到类型的

	public RuleEsSettingBean(Rule rule, String relakey, String many) {
		this.rule = rule;
		this.relakey = relakey;
		this.tomany = StringUtil.isNotNull(many) && "yes".equals(many) ? true : false;
	}

	public String getCurColName() {
		return String.format(format, rule.getDbOri(), rule.getTbOri());
	}

	@Override
	public boolean equals(Object obj) {
		RuleEsSettingBean temp = (RuleEsSettingBean) obj;
		return this.getCurColName().equals(temp.getCurColName());
	}

	@Override
	public int hashCode() {
		return this.getCurColName().hashCode();
	}

//	public Map<Rule, Pair<String, Boolean>> getRelaMap(){
//		return this.relaMap;
//	}

//	// 默认15分片
//	@Builder.Default
//	private int shardsNum = 15;
//
//	// test:user_info|test:user_addr:user_id:true
//	public static IndexParamsNoJoinBean buildByConf(String esSetting) {
//		if (StringUtil.isNull(esSetting)) {
//			return null;
//		}
//		IndexParamsNoJoinBeanBuilder builder = IndexParamsNoJoinBean.builder();
//		Map<String, IndexSetting> tableMap = new HashMap<String, IndexSetting>();
//		extracted(esSetting, builder, tableMap);
//		builder.tableMap(tableMap);
//		return builder.build();
//	}
//
//	private static void extracted(String esSetting,Rule rule,IndexParamsNoJoinBeanBuilder builder) {
//		for (String setting : esSetting.split("\\|")) {
//			String[] item = setting.split(":");
//			if (item.length != 2 && item.length != 4) {
//				throw new ProjectExceptionRuntime(ExceptAll.param_error, "参数个数为2或4");
//			}
//			if (item.length == 2) {
//				builder.rule(rule);
//			}else {
//				builder.
//			}
//			
//			
////			IndexSetting temp = new IndexSetting();
////			temp.setDb(item[0]);
////			temp.setTb(item[1]);
//			if (item.length == 2) {
//				builder.db(item[0]);
//				builder.tb(item[1]);
//			} else if (item.length == 4) {
//				temp.setRelacol(item[2]);
//				temp.setTomany(Boolean.parseBoolean(item[3]));
//			}
//			tableMap.put(String.format(IndexSetting.formate, item[0], item[1]), temp);
//		}
//	}
//	
//	public void addIndexSetting(String esSetting) {
//		extracted(esSetting,this.builder(),this.tableMap);
//	}

}
