package net.wicp.tams.common.es.bean;

import java.util.ArrayList;
import java.util.List;

import lombok.Data;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleManager;

@Data
public class IndexParamsNoJoin {
	private final String index;
	private Rule rootRule;
	private final List<RuleEsSettingBean> colBeans = new ArrayList<RuleEsSettingBean>();

	// 默认15分片
	private int shardsNum = 15;

	private IndexParamsNoJoin(Rule rule) {
		this.index = rule.getItems().get(RuleItem.index);
		if (rule.getParent() == null) {
			this.rootRule = rule;
		}
	}

	public void addRuleEsSettingBean(RuleEsSettingBean ruleEsSettingBean) {
		this.colBeans.add(ruleEsSettingBean);
	}

	// 规则配置
	public static List<IndexParamsNoJoin> buildByConf(String rulesstr) {
		if (StringUtil.isNull(rulesstr)) {
			return null;
		}
		List<IndexParamsNoJoin> retlist = new ArrayList<IndexParamsNoJoin>();
		RuleManager manager = new RuleManager(rulesstr);

		for (Rule rule : manager.getRules()) {
			IndexParamsNoJoin temp = new IndexParamsNoJoin(rule);
			int indexOf = retlist.indexOf(temp);
			if (indexOf < 0) {
				retlist.add(temp);
			} else {
				temp = retlist.get(indexOf);
			}
			if (rule.getParent() == null) {// 是根rule，则设置好根
				temp.setRootRule(rule);
			} else {// 不是根，则要加到colBeans
				String many = StringUtil.trimSpace(rule.getItems().get(RuleItem.many));
				String relakey = StringUtil.trimSpace(rule.getItems().get(RuleItem.relakey));
				// parent由RuleItem.parent指定
				RuleEsSettingBean ruleEsSettingBean = new RuleEsSettingBean(rule, relakey,many);
				temp.addRuleEsSettingBean(ruleEsSettingBean);
			}
		}
		return retlist;
	}
	
	public static IndexParamsNoJoin findByIndex(List<IndexParamsNoJoin> paramslist,String indexName) {
		IndexParamsNoJoin retobj=null;
		for (IndexParamsNoJoin indexParamsNoJoin : paramslist) {
			if(indexName.equalsIgnoreCase(indexParamsNoJoin.getIndex())) {
				retobj =indexParamsNoJoin;
				break;
			}
		}
		return retobj;
	}

	@Override
	public boolean equals(Object obj) {
		IndexParamsNoJoin temp = (IndexParamsNoJoin) obj;
		return this.getIndex().equals(temp.getIndex());
	}

	@Override
	public int hashCode() {
		return this.getIndex().hashCode();
	}

}
