package net.wicp.tams.common.es.bean;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import lombok.Builder;
import lombok.Data;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.SimpleTreeNode;

/***
 * 创建索引用的辅助bean,join类型暂时只支持2张表
 * 
 * @author andy.zhou
 *
 */
@Data
@Builder
public class IndexParamsBean {
	private String db;
	private String tb;
	// private String primary;
	// 第一个从表
	private String db1;
	private String tb1;
	private String rela1;
	// 默认15分片
	@Builder.Default
	private int shardsNum = 15;

//	private static IndexParamsBean buildJson(String jsonstr) {
//		JSONObject parObj = JSONObject.parseObject(jsonstr);
//		IndexParamsBeanBuilder retobj = IndexParamsBean.builder();
//		if (parObj.containsKey("db")) {
//			retobj.db(parObj.getString("db"));
//		}
//		if (parObj.containsKey("tb")) {
//			retobj.tb(parObj.getString("tb"));
//		}
//		if (parObj.containsKey("db1")) {
//			retobj.db1(parObj.getString("db1"));
//		}
//		if (parObj.containsKey("tb1")) {
//			retobj.tb1(parObj.getString("tb1"));
//		}
//		if (parObj.containsKey("rela1")) {
//			retobj.rela1(parObj.getString("rela1"));
//		}
//		if (parObj.containsKey("shardsNum")) {
//			retobj.shardsNum(parObj.getIntValue("shardsNum"));
//		}
//		return retobj.build();
//	}

	// eg: db:test|tb:user_info|db1:test|tb1:user_addr|rela1:user_id|shardsNum:12
//	public static IndexParamsBean buildFormat(String esSetting) {
//		JSONObject settingJson = new JSONObject();
//		for (String setting : esSetting.split("\\|")) {
//			String[] item = setting.split(":");
//			if (item.length != 2) {
//				throw new ProjectExceptionRuntime(ExceptAll.param_error, "参数个数为2");
//			}
//			settingJson.put(item[0], item[1]);
//		}
//		return buildJson(settingJson.toJSONString());
//	}

	public static IndexParamsBean buildFormat(IndexParamsNoJoin param) {
		IndexParamsBean ret = null;
		if (CollectionUtils.isNotEmpty(param.getColBeans())) {
			RuleEsSettingBean ruleEsSettingBean = param.getColBeans().get(0);// 暂时只支持2张表的join
			ret = new IndexParamsBean(param.getRootRule().getDbOri(), param.getRootRule().getTbOri(),
					ruleEsSettingBean.getRule().getDbOri(), ruleEsSettingBean.getRule().getTbOri(),
					ruleEsSettingBean.getRelakey(), param.getShardsNum());
		} else {// 单表
			ret = new IndexParamsBean(param.getRootRule().getDbOri(), param.getRootRule().getTbOri(), null, null, null,
					param.getShardsNum());
		}
		return ret;
	}

	public List<SimpleTreeNode> buildRelaNodes() {
		if (StringUtil.isNull(rela1)) {
			return null;
		}
		List<SimpleTreeNode> retlist = new ArrayList<>();
		SimpleTreeNode node = new SimpleTreeNode(tb, null);
		String subrela = String.format("%s:%s", tb1, rela1);
		SimpleTreeNode node2 = new SimpleTreeNode(subrela, tb);
		retlist.add(node);
		retlist.add(node2);
		return retlist;
	}
}
