/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.es.bean;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.es.bean.IndexSetting;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

public class IndexParamsNoJoinBean {
    private String db;
    private String tb;
    private Map<String, IndexSetting> tableMap;
    private int shardsNum;

    public static IndexParamsNoJoinBean buildByConf(String esSetting) {
        if (StringUtil.isNull((Object)esSetting)) {
            return null;
        }
        IndexParamsNoJoinBeanBuilder builder = IndexParamsNoJoinBean.builder();
        HashMap<String, IndexSetting> tableMap = new HashMap<String, IndexSetting>();
        IndexParamsNoJoinBean.extracted(esSetting, builder, tableMap);
        builder.tableMap(tableMap);
        return builder.build();
    }

    private static void extracted(String esSetting, IndexParamsNoJoinBeanBuilder builder, Map<String, IndexSetting> tableMap) {
        for (String setting : esSetting.split("\\|")) {
            String[] item = setting.split(":");
            if (item.length != 2 && item.length != 4) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, "\u53c2\u6570\u4e2a\u6570\u4e3a2\u62164");
            }
            IndexSetting temp = new IndexSetting();
            temp.setDb(item[0]);
            temp.setTb(item[1]);
            if (item.length == 2) {
                builder.db(item[0]);
                builder.tb(item[1]);
            } else if (item.length == 4) {
                temp.setRelacol(item[2]);
                temp.setTomany(Boolean.parseBoolean(item[3]));
            }
            tableMap.put(String.format(IndexSetting.formate, item[0], item[1]), temp);
        }
    }

    public void addIndexSetting(String esSetting) {
        IndexParamsNoJoinBean.extracted(esSetting, this.builder(), this.tableMap);
    }

    private static int $default$shardsNum() {
        return 15;
    }

    @ConstructorProperties(value={"db", "tb", "tableMap", "shardsNum"})
    IndexParamsNoJoinBean(String db, String tb, Map<String, IndexSetting> tableMap, int shardsNum) {
        this.db = db;
        this.tb = tb;
        this.tableMap = tableMap;
        this.shardsNum = shardsNum;
    }

    public static IndexParamsNoJoinBeanBuilder builder() {
        return new IndexParamsNoJoinBeanBuilder();
    }

    public String getDb() {
        return this.db;
    }

    public String getTb() {
        return this.tb;
    }

    public Map<String, IndexSetting> getTableMap() {
        return this.tableMap;
    }

    public int getShardsNum() {
        return this.shardsNum;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public void setTb(String tb) {
        this.tb = tb;
    }

    public void setTableMap(Map<String, IndexSetting> tableMap) {
        this.tableMap = tableMap;
    }

    public void setShardsNum(int shardsNum) {
        this.shardsNum = shardsNum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexParamsNoJoinBean)) {
            return false;
        }
        IndexParamsNoJoinBean other = (IndexParamsNoJoinBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$db = this.getDb();
        String other$db = other.getDb();
        if (this$db == null ? other$db != null : !this$db.equals(other$db)) {
            return false;
        }
        String this$tb = this.getTb();
        String other$tb = other.getTb();
        if (this$tb == null ? other$tb != null : !this$tb.equals(other$tb)) {
            return false;
        }
        Map<String, IndexSetting> this$tableMap = this.getTableMap();
        Map<String, IndexSetting> other$tableMap = other.getTableMap();
        if (this$tableMap == null ? other$tableMap != null : !((Object)this$tableMap).equals(other$tableMap)) {
            return false;
        }
        return this.getShardsNum() == other.getShardsNum();
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexParamsNoJoinBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $db = this.getDb();
        result = result * 59 + ($db == null ? 43 : $db.hashCode());
        String $tb = this.getTb();
        result = result * 59 + ($tb == null ? 43 : $tb.hashCode());
        Map<String, IndexSetting> $tableMap = this.getTableMap();
        result = result * 59 + ($tableMap == null ? 43 : ((Object)$tableMap).hashCode());
        result = result * 59 + this.getShardsNum();
        return result;
    }

    public String toString() {
        return "IndexParamsNoJoinBean(db=" + this.getDb() + ", tb=" + this.getTb() + ", tableMap=" + this.getTableMap() + ", shardsNum=" + this.getShardsNum() + ")";
    }

    public static class IndexParamsNoJoinBeanBuilder {
        private String db;
        private String tb;
        private Map<String, IndexSetting> tableMap;
        private boolean shardsNum$set;
        private int shardsNum;

        IndexParamsNoJoinBeanBuilder() {
        }

        public IndexParamsNoJoinBeanBuilder db(String db) {
            this.db = db;
            return this;
        }

        public IndexParamsNoJoinBeanBuilder tb(String tb) {
            this.tb = tb;
            return this;
        }

        public IndexParamsNoJoinBeanBuilder tableMap(Map<String, IndexSetting> tableMap) {
            this.tableMap = tableMap;
            return this;
        }

        public IndexParamsNoJoinBeanBuilder shardsNum(int shardsNum) {
            this.shardsNum = shardsNum;
            this.shardsNum$set = true;
            return this;
        }

        public IndexParamsNoJoinBean build() {
            return new IndexParamsNoJoinBean(this.db, this.tb, this.tableMap, this.shardsNum$set ? this.shardsNum : IndexParamsNoJoinBean.$default$shardsNum());
        }

        public String toString() {
            return "IndexParamsNoJoinBean.IndexParamsNoJoinBeanBuilder(db=" + this.db + ", tb=" + this.tb + ", tableMap=" + this.tableMap + ", shardsNum=" + this.shardsNum + ")";
        }
    }
}

