package net.wicp.tams.common.es.bean;

import java.util.HashMap;
import java.util.Map;

import lombok.Builder;
import lombok.Data;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

/***
 * 创建索引用的辅助bean,用于all in one类型
 * 
 * @author andy.zhou
 *
 */
@Data
@Builder
public class IndexParamsNoJoinBean {
	private String db;
	private String tb;
	private Map<String, IndexSetting> tableMap;

	// 默认15分片
	@Builder.Default
	private int shardsNum = 15;

	// test:user_info|test:user_addr:user_id:true
	public static IndexParamsNoJoinBean buildByConf(String esSetting) {
		if (StringUtil.isNull(esSetting)) {
			return null;
		}
		IndexParamsNoJoinBeanBuilder builder = IndexParamsNoJoinBean.builder();
		Map<String, IndexSetting> tableMap = new HashMap<String, IndexSetting>();
		extracted(esSetting, builder, tableMap);
		builder.tableMap(tableMap);
		return builder.build();
	}

	private static void extracted(String esSetting, IndexParamsNoJoinBeanBuilder builder,
			Map<String, IndexSetting> tableMap) {
		for (String setting : esSetting.split("\\|")) {
			String[] item = setting.split(":");
			if (item.length != 2 && item.length != 4) {
				throw new ProjectExceptionRuntime(ExceptAll.param_error, "参数个数为2或4");
			}
			IndexSetting temp = new IndexSetting();
			temp.setDb(item[0]);
			temp.setTb(item[1]);
			if (item.length == 2) {
				builder.db(item[0]);
				builder.tb(item[1]);
			} else if (item.length == 4) {
				temp.setRelacol(item[2]);
				temp.setTomany(Boolean.parseBoolean(item[3]));
			}
			tableMap.put(String.format(IndexSetting.formate, item[0], item[1]), temp);
		}
	}
	
	public void addIndexSetting(String esSetting) {
		extracted(esSetting,this.builder(),this.tableMap);
	}

	

}
