/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.es.constant;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public enum ClusterSettings {
    store_throttle_type("\u5408\u5e76\u7684\u9608\u503c", "indices.store.throttle.type", Type.TRANSIENT, new String[]{"merge", "not", "all"});

    private final String desc;
    private final String key;
    private final Type type;
    private final String[] values;

    private ClusterSettings(String desc, String key, Type type, String[] values) {
        this.desc = desc;
        this.key = key;
        this.type = type;
        this.values = values;
    }

    public String getDesc() {
        return this.desc;
    }

    public Type getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String[] getValues() {
        return this.values;
    }

    public void valid(String value) {
        Validate.notBlank((CharSequence)value);
        if (ArrayUtils.isEmpty((Object[])this.values)) {
            return;
        }
        Validate.isTrue((boolean)ArrayUtils.contains((Object[])this.values, (Object)value));
    }

    public static enum Type {
        PERSISTENT,
        TRANSIENT;

    }
}

