package net.wicp.tams.common.es;

import java.io.IOException;
import java.lang.reflect.Type;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;

import net.wicp.tams.common.es.bean.MappingBean;

public class MappingEnumSerializer implements ObjectSerializer {

	public final static MappingEnumSerializer instance = new MappingEnumSerializer();

	@Override
	public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features)
			throws IOException {
		SerializeWriter out = serializer.out;
		if (object instanceof MappingBean.Dynamic) {
			MappingBean.Dynamic enumele = (MappingBean.Dynamic) object;
			out.write("\"" + enumele.getValue() + "\"");
		} else if (object instanceof MappingBean.DataTypes) {
			MappingBean.DataTypes enumele = (MappingBean.DataTypes) object;
			out.write("\"" + enumele.getValue() + "\"");
		} else {
			out.writeEnum((Enum<?>) object);
		}
	}

}