/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.es;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.apiext.json.SimpleTreeNode;
import net.wicp.tams.common.apiext.json.easyuibean.EasyUINode;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.es.Action;
import net.wicp.tams.common.es.EsData;
import net.wicp.tams.common.es.EsObj;
import net.wicp.tams.common.es.MappingEnumSerializer;
import net.wicp.tams.common.es.RelaValue;
import net.wicp.tams.common.es.UpdateSet;
import net.wicp.tams.common.es.bean.IndexParamsBean;
import net.wicp.tams.common.es.bean.MappingBean;
import net.wicp.tams.common.es.constant.OptTemp;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EsAssit {
    private static final Logger log = LoggerFactory.getLogger(EsAssit.class);

    public static MappingBean proMappingBean(Connection conn, IndexParamsBean mapping) {
        String[][] cols = MySqlAssit.getCols((Connection)conn, (String)mapping.getDb(), (String)mapping.getTb(), (YesOrNo)YesOrNo.yes);
        if (StringUtil.isNotNull((Object)mapping.getDb1()) && StringUtil.isNotNull((Object)mapping.getTb1())) {
            String[][] cols1 = MySqlAssit.getCols((Connection)conn, (String)mapping.getDb1(), (String)mapping.getTb1(), (YesOrNo)YesOrNo.yes);
            String[] nameAry = (String[])CollectionUtil.arrayMerge(String[].class, (Object[])cols[0], (Object[])cols1[0]);
            String[] typeAry = (String[])CollectionUtil.arrayMerge(String[].class, (Object[])cols[1], (Object[])cols1[1]);
            cols = new String[][]{nameAry, typeAry};
        }
        if (ArrayUtils.isEmpty((Object[])cols) || "_rowkey_".equals(cols[0][0])) {
            log.error("\u6ca1\u6709\u5217\u6216\u4f20\u5165\u7684\u8868\u6ca1\u6709\u4e3b\u952e");
            return null;
        }
        String contentjson = EsAssit.packIndexContent(cols[0], cols[1], mapping.buildRelaNodes());
        MappingBean proMappingBean = null;
        try {
            proMappingBean = MappingBean.proMappingBean(contentjson);
        }
        catch (Exception e) {
            log.error("\u521b\u5efaMappingBean\u5931\u8d25", (Throwable)e);
            return null;
        }
        return proMappingBean;
    }

    public static CreateIndexRequest indexCreate(Connection conn, IndexParamsBean mapping, String indexName, String type, int shardsNum, int replicas, String alias) {
        MappingBean proMappingBean = EsAssit.proMappingBean(conn, mapping);
        if (proMappingBean == null) {
            return null;
        }
        CreateIndexRequest indexCreate = EsAssit.indexCreate(indexName, type, shardsNum, replicas, alias, proMappingBean);
        return indexCreate;
    }

    public static String BulkPack(EsData esData) {
        EsAssit.valid(esData);
        StringBuffer buff = new StringBuffer();
        for (EsObj esObj : esData.getDatasList()) {
            String head = "";
            head = StringUtil.isNull((Object)esObj.getId()) && esData.getAction() == Action.create ? String.format(OptTemp.actionBulkTempNoId.getValue(), esData.getAction().name(), esData.getIndex(), esData.getType()) : String.format(OptTemp.actionBulkTemp.getValue(), esData.getAction().name(), esData.getIndex(), esData.getType(), esObj.getId());
            buff.append(head);
            if (esData.getAction() == Action.delete) continue;
            String jsonString = JSONObject.toJSONString(esObj.getSourceMap(), (boolean)false);
            buff.append(jsonString);
            buff.append("\n");
        }
        buff.delete(buff.length() - 2, buff.length() - 1);
        return buff.toString();
    }

    public static String BulkPack(List<EsData> esDatas) {
        StringBuffer buff = new StringBuffer();
        for (EsData esData : esDatas) {
            buff.append(EsAssit.BulkPack(esData));
            buff.append("\n");
        }
        buff.delete(buff.length() - 2, buff.length() - 1);
        return buff.toString();
    }

    public static void valid(EsData esData) {
        Validate.isTrue((esData != null ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((esData.getAction() != Action.create || esData.getAction() != Action.index || esData.getDatasCount() > 0 ? 1 : 0) != 0, (String)"create/index \u9700\u8981Datas\u6570\u636e", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)esData.getAction()), (String)"action\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)esData.getIndex(), (String)"index\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)esData.getType(), (String)"type\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<EsObj> datasList = esData.getDatasList();
        Validate.isTrue((datasList.size() > 0 ? 1 : 0) != 0, (String)"\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (Object[])new Object[0]);
        if (esData.getAction() == Action.create) {
            return;
        }
        boolean updateSetAll = false;
        if (esData.getAction() == Action.update && esData.hasUpdateSet() && (esData.getUpdateSet().getDoc() || esData.getUpdateSet().getUpsert() || StringUtil.isNotNull((Object)esData.getUpdateSet().getScript()))) {
            updateSetAll = true;
        }
        for (EsObj esObj : datasList) {
            if ((esData.getAction() == Action.index || esData.getAction() == Action.delete || esData.getAction() == Action.update) && StringUtil.isNull((Object)esObj.getId())) {
                log.warn("\u65e0id\u7684\u6570\u636e\uff0c\u5c06\u4f1a\u8df3\u8fc7\u4e0d\u5904\u7406\uff1a{}", (Object)esObj);
            }
            if (esData.getAction() != Action.update || updateSetAll) continue;
            Validate.isTrue((boolean)esObj.hasUpdateSet(), (String)"\u66f4\u65b0\u64cd\u4f5c\u9700\u8981\u4f20\u5165updateSet\u5143\u7d20", (Object[])new Object[0]);
            Validate.isTrue((esObj.getUpdateSet().getDoc() || esObj.getUpdateSet().getUpsert() || StringUtil.isNotNull((Object)esObj.getUpdateSet().getScript()) ? 1 : 0) != 0, (String)"update\u64cd\u4f5c,doc/upset/script \u4e09\u8005\u5fc5\u987b\u8981\u4e00\u4e2a\u8d77\u4f5c\u7528", (Object[])new Object[0]);
        }
    }

    public static <T extends Serializable> EsData esData(T data, Action action, String idColName, String index, String type, UpdateSet updateSet) {
        Validate.notNull(data, (String)"\u539f\u59cb\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)action), (String)"action\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)index, (String)"index\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)type, (String)"type\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        EsData.Builder newBuilder = EsData.newBuilder();
        newBuilder.setAction(action);
        newBuilder.setIndex(index);
        newBuilder.setType(type);
        newBuilder.setIsFast(false);
        EsObj.Builder esObjBuilder = EsObj.newBuilder();
        if (StringUtil.isNotNull((Object)idColName)) {
            if (data instanceof JSONObject) {
                esObjBuilder.setId(((JSONObject)data).getString(idColName));
            } else if (ReflectAssist.isInterface(data.getClass(), (String)"java.util.Map")) {
                Object obj = ((Map)((Object)data)).get(idColName);
                esObjBuilder.setId(String.valueOf(obj));
            } else {
                try {
                    Object idObj = PropertyUtils.getProperty(data, (String)idColName);
                    esObjBuilder.setId(String.valueOf(idObj));
                }
                catch (Exception e) {
                    log.error("\u53d6id\u503c\u51fa\u9519\u4e86", (Throwable)e);
                    throw new RuntimeException("\u53d6id\u503c\u51fa\u9519\u4e86", e);
                }
            }
        }
        if (action == Action.update && updateSet != null) {
            esObjBuilder.setUpdateSet(updateSet);
        }
        Map map = null;
        if (data instanceof JSONObject) {
            map = (Map)((JSONObject)data).toJavaObject(Map.class);
        } else if (!ReflectAssist.isInterface(data.getClass(), (String)"java.util.Map")) {
            map = ReflectAssist.convertMapFromBean(data);
        }
        CollectionUtil.filterNull((Map)map, (int)1);
        esObjBuilder.putAllSource(map);
        newBuilder.addDatas(esObjBuilder.build());
        EsData esData = newBuilder.build();
        EsAssit.valid(esData);
        return esData;
    }

    public static <T extends Serializable> EsData esDataUpdate(T data, String idColName, String index, String type, UpdateSet updateSet) {
        return EsAssit.esData(data, Action.update, idColName, index, type, updateSet);
    }

    public static <T extends Serializable> EsData esDataUpdate(String[] datas, String[] fields, String idColName, String index, String type, UpdateSet updateSet) {
        Validate.notEmpty((Object[])datas);
        Validate.notEmpty((Object[])fields);
        Validate.isTrue((fields.length == datas.length ? 1 : 0) != 0);
        JSONObject inputobj = new JSONObject();
        for (int i = 0; i < fields.length; ++i) {
            inputobj.put(fields[i], (Object)datas[i]);
        }
        return EsAssit.esData(inputobj, Action.update, idColName, index, type, updateSet);
    }

    public static <T extends Serializable> EsData esDataUpsert(String[] datas, String[] fields, String idColName, String index, String type) {
        UpdateSet build = UpdateSet.newBuilder().setUpsert(true).build();
        return EsAssit.esDataUpdate(datas, fields, idColName, index, type, build);
    }

    public static <T extends Serializable> EsData esDataDel(String[] datas, String[] fields, String idColName, String index, String type) {
        Validate.notEmpty((Object[])datas);
        Validate.notEmpty((Object[])fields);
        Validate.isTrue((fields.length == datas.length ? 1 : 0) != 0);
        int idIndexOf = ArrayUtils.indexOf((Object[])fields, (Object)idColName);
        String idvalue = datas[idIndexOf];
        JSONObject input = new JSONObject();
        input.put(idColName, (Object)idvalue);
        return EsAssit.esData(input, Action.delete, idColName, index, type, null);
    }

    private static void addCommon(DocWriteRequest docWriteRequest, EsObj esObj) {
        if (esObj.hasRelaValue()) {
            RelaValue relaValue = esObj.getRelaValue();
            docWriteRequest.routing(relaValue.getParent());
        }
    }

    public static List<DocWriteRequest> packRequest(EsData esData, Map<String, MappingBean.DataTypes> mapping) {
        EsAssit.valid(esData);
        ArrayList<DocWriteRequest> retlist = new ArrayList<DocWriteRequest>();
        switch (esData.getAction()) {
            case create: {
                for (EsObj esObj : esData.getDatasList()) {
                    IndexRequest createRequest = new IndexRequest(esData.getIndex(), esData.getType());
                    createRequest.create(true);
                    if (StringUtils.isNotEmpty((CharSequence)esObj.getId())) {
                        createRequest.id(esObj.getId());
                    }
                    createRequest.source(EsAssit.packJson(esObj, mapping), XContentType.JSON);
                    EsAssit.addCommon((DocWriteRequest)createRequest, esObj);
                    retlist.add((DocWriteRequest)createRequest);
                }
                break;
            }
            case index: {
                for (EsObj esObj : esData.getDatasList()) {
                    if (StringUtil.isNull((Object)esObj.getId())) continue;
                    IndexRequest indexRequest = EsAssit.packIndex(esData, esObj, mapping);
                    EsAssit.addCommon((DocWriteRequest)indexRequest, esObj);
                    retlist.add((DocWriteRequest)indexRequest);
                }
                break;
            }
            case update: {
                for (EsObj esObj : esData.getDatasList()) {
                    if (StringUtil.isNull((Object)esObj.getId())) continue;
                    UpdateSet updateSetTrue = esObj.hasUpdateSet() ? esObj.getUpdateSet() : esData.getUpdateSet();
                    UpdateRequest updateReques = new UpdateRequest(esData.getIndex(), esData.getType(), esObj.getId());
                    if (updateSetTrue.getDoc()) {
                        IndexRequest indexRequest = EsAssit.packIndex(esData, esObj, mapping);
                        updateReques.doc(indexRequest);
                        EsAssit.addCommon((DocWriteRequest)updateReques, esObj);
                        retlist.add((DocWriteRequest)updateReques);
                        continue;
                    }
                    if (updateSetTrue.getUpsert()) {
                        IndexRequest createRequest = new IndexRequest(esData.getIndex(), esData.getType(), esObj.getId());
                        createRequest.source(EsAssit.packJson(esObj, mapping), XContentType.JSON);
                        EsAssit.addCommon((DocWriteRequest)createRequest, esObj);
                        retlist.add((DocWriteRequest)createRequest);
                        continue;
                    }
                    if (!StringUtil.isNotNull((Object)updateSetTrue.getScript())) continue;
                    Script script = new Script(updateSetTrue.getScript());
                    updateReques.script(script);
                    if (StringUtil.isNotNull((Object)updateSetTrue.getParams())) {
                        JSONObject paramObj = JSONObject.parseObject((String)updateSetTrue.getParams());
                        for (String paramkey : paramObj.keySet()) {
                            updateReques.addScriptParam(paramkey, paramObj.get((Object)paramObj));
                        }
                    }
                    EsAssit.addCommon((DocWriteRequest)updateReques, esObj);
                    retlist.add((DocWriteRequest)updateReques);
                }
                break;
            }
            case delete: {
                for (EsObj esObj : esData.getDatasList()) {
                    if (StringUtil.isNull((Object)esObj.getId())) continue;
                    DeleteRequest deleteRequest = new DeleteRequest(esData.getIndex(), esData.getType(), esObj.getId());
                    EsAssit.addCommon((DocWriteRequest)deleteRequest, esObj);
                    retlist.add((DocWriteRequest)deleteRequest);
                }
                break;
            }
        }
        return retlist;
    }

    public static JSONObject getRelationsJson(List<SimpleTreeNode> nodes) {
        if (CollectionUtils.isEmpty(nodes) || nodes.size() == 1) {
            return null;
        }
        List roots = SimpleTreeNode.createTree(nodes);
        if (CollectionUtils.isEmpty((Collection)roots) || roots.size() > 1) {
            return null;
        }
        EasyUINode root = (EasyUINode)roots.get(0);
        JSONObject relaObj = new JSONObject();
        for (SimpleTreeNode node : nodes) {
            EasyUINode curNode = node.getId().equals(root.getId()) ? root : root.getSubById(node.getId());
            List childrens = curNode.getChildrens();
            if (!CollectionUtils.isNotEmpty((Collection)childrens)) continue;
            if (childrens.size() == 1) {
                relaObj.put(node.getId(), (Object)((EasyUINode)childrens.get(0)).getId());
                continue;
            }
            JSONArray arry = new JSONArray();
            for (EasyUINode children : childrens) {
                arry.add((Object)children.getId());
            }
            relaObj.put(node.getId(), (Object)arry);
        }
        JSONObject retobj = new JSONObject();
        retobj.put("relations", (Object)relaObj);
        retobj.put("eager_global_ordinals", (Object)true);
        retobj.put("type", (Object)"join");
        return retobj;
    }

    public static String packIndexContent(String[] colName, String[] colType, List<SimpleTreeNode> nodes) {
        Validate.notEmpty((Object[])colName);
        Validate.notEmpty((Object[])colType);
        Validate.isTrue((colName.length == colType.length ? 1 : 0) != 0);
        JSONObject retobj = new JSONObject();
        for (int i = 0; i < colName.length; ++i) {
            BinlogType mysqlType = BinlogType.getByName((String)colType[i]);
            MappingBean.DataTypes dataTypes = MappingBean.DataTypes.getDataTypesByMysqlType(mysqlType);
            retobj.put(colName[i], (Object)dataTypes.getValue());
        }
        if (CollectionUtils.isNotEmpty(nodes)) {
            retobj.put(Conf.get((String)"common.es.assit.rela.key"), (Object)EsAssit.getRelationsJson(nodes));
        }
        return JSON.toJSONString((Object)retobj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.UseSingleQuotes});
    }

    public static String packIndexContent(String[] colName, String[] colType) {
        return EsAssit.packIndexContent(colName, colType, null);
    }

    public static CreateIndexRequest indexCreate(String indexName, String type, int shardsNum, int replicas, String alias, MappingBean mappingBean) {
        Validate.notEmpty((CharSequence)indexName);
        Validate.isTrue((shardsNum > 0 ? 1 : 0) != 0);
        Validate.isTrue((replicas >= 0 ? 1 : 0) != 0);
        Validate.notNull((Object)mappingBean);
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        request.settings(Settings.builder().put("index.number_of_shards", shardsNum).put("index.number_of_replicas", replicas));
        String jsonString2 = EsAssit.mappingFormat(type, mappingBean);
        request.mapping(type, jsonString2, XContentType.JSON);
        if (StringUtil.isNotNull((Object)alias)) {
            request.alias(new Alias(alias));
        }
        return request;
    }

    public CreateIndexRequest indexCreate(String indexName, String type, int shardsNum, int replicas, MappingBean mappingBean) {
        return EsAssit.indexCreate(indexName, type, shardsNum, replicas, null, mappingBean);
    }

    public CreateIndexRequest indexCreate(String indexName, String type, int shardsNum, MappingBean mappingBean) {
        return EsAssit.indexCreate(indexName, type, shardsNum, 0, null, mappingBean);
    }

    private static String mappingFormat(String type, MappingBean mappingBean) {
        SerializeConfig tamsSerializeConfig = SerializeConfig.getGlobalInstance();
        tamsSerializeConfig.put(MappingBean.DataTypes.class, (ObjectSerializer)MappingEnumSerializer.instance);
        tamsSerializeConfig.put(MappingBean.Dynamic.class, (ObjectSerializer)MappingEnumSerializer.instance);
        String jsonString = JSON.toJSONString((Object)JSONUtil.packParams((Object[])new Object[]{type, mappingBean}), (SerializeConfig)tamsSerializeConfig, (SerializerFeature[])new SerializerFeature[0]);
        String jsonString2 = JSON.toJSONString((Object)JSON.parse((String)jsonString), (boolean)true);
        return jsonString2;
    }

    private static IndexRequest packIndex(EsData esData, EsObj esObj, Map<String, MappingBean.DataTypes> mapping) {
        IndexRequest indexRequest = new IndexRequest(esData.getIndex(), esData.getType(), esObj.getId());
        indexRequest.create(false);
        indexRequest.source(EsAssit.packJson(esObj, mapping), XContentType.JSON);
        return indexRequest;
    }

    private static String packJson(EsObj esObj, Map<String, MappingBean.DataTypes> mapping) {
        JSONObject tempobj = new JSONObject();
        Map<String, String> sourceMap = esObj.getSourceMap();
        for (String key : sourceMap.keySet()) {
            MappingBean.DataTypes dataTypes = mapping.get(key);
            if (dataTypes == null) continue;
            try {
                Object obj = dataTypes.getConvertObj(sourceMap.get(key));
                if (obj != null) {
                    tempobj.put(key, obj);
                    continue;
                }
                log.error("---------------------------\u5904\u7406\u5931\u8d25\uff0c\u9700\u8981\u534f\u67e5\uff0ctype:{},key:{},value:{}-----------------------------", new Object[]{dataTypes.name(), key, sourceMap.get(key)});
            }
            catch (Throwable e) {
                log.error("---------------------------\u5904\u7406\u5931\u8d25\uff0c\u9700\u8981\u534f\u67e5\uff0ctype:{},key:{},value:{}-----------------------------", new Object[]{dataTypes.name(), key, sourceMap.get(key)});
            }
        }
        if (esObj.hasRelaValue()) {
            if (esObj.getRelaValue().getParent().isEmpty()) {
                tempobj.put(Conf.get((String)"common.es.assit.rela.key"), (Object)esObj.getRelaValue().getName());
            } else {
                String json = new JsonFormat().printToString((Message)esObj.getRelaValue());
                JSONObject relaObj = JSONObject.parseObject((String)json);
                tempobj.put(Conf.get((String)"common.es.assit.rela.key"), (Object)relaObj);
            }
        }
        String jsonString = tempobj.toJSONString();
        return jsonString;
    }

    static {
        if (StringUtil.isNull((Object)Conf.get((String)"common.es.assit.rela.key"))) {
            Properties assitDefault = IOUtil.fileToProperties((String)"/common-es-assit.properties", EsAssit.class);
            Conf.overProp((Properties)assitDefault);
        }
    }
}

