/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.es.bean;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.apiext.DateUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertObj;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.es.MappingEnumSerializer;
import org.apache.commons.lang3.ArrayUtils;

public class MappingBean {
    private Map<String, Propertie> properties;
    private Dynamic dynamic;
    private Boolean enabled;

    public static MappingBean proMappingBean(Boolean canIndex, String jsonstr) {
        MappingBeanBuilder builder = MappingBean.builder().dynamic(Dynamic.STRICT).enabled(canIndex == null ? true : canIndex);
        JSONObject parseObject = JSON.parseObject((String)jsonstr);
        HashMap<String, Propertie> properties = new HashMap<String, Propertie>();
        for (String key : parseObject.keySet()) {
            Propertie propertieBuilder = new Propertie();
            DataTypes dataType = null;
            try {
                JSONObject jsonObject = parseObject.getJSONObject(key);
                dataType = DataTypes.getDataTypeByName(jsonObject);
                if (jsonObject.containsKey((Object)"relations")) {
                    propertieBuilder.setRelations(jsonObject.getJSONObject("relations"));
                }
            }
            catch (Exception e) {
                dataType = DataTypes.getDataTypeByName(parseObject.getString(key));
            }
            if (dataType == null) {
                throw new RuntimeException("\u9519\u8bef\u7684mapping\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5key:[" + key + "]\u7684\u7c7b\u578b");
            }
            propertieBuilder.setType(dataType);
            properties.put(key, propertieBuilder);
        }
        builder.properties(properties);
        return builder.build();
    }

    public static MappingBean proMappingBean(String jsonstr) {
        return MappingBean.proMappingBean(true, jsonstr);
    }

    public static boolean isRoot(JSONObject relations, String eleName) {
        if (relations == null || relations.size() == 0) {
            return true;
        }
        if (!relations.containsKey((Object)eleName)) {
            return false;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Object value : relations.values()) {
            try {
                String tempv = (String)value;
                values.add(tempv.split(":")[0]);
            }
            catch (Exception e) {
                JSONArray ary = (JSONArray)value;
                for (Object object : ary) {
                    values.add(String.valueOf(object).split(":")[0]);
                }
            }
        }
        return !values.contains(eleName);
    }

    public static String getRelaName(JSONObject relations, String tableName) {
        for (Object value : relations.values()) {
            try {
                String tempv = (String)value;
                if (!tempv.startsWith(tableName + ":")) continue;
                return tempv;
            }
            catch (Exception e) {
                JSONArray ary = (JSONArray)value;
                for (Object object : ary) {
                    if (!String.valueOf(object).startsWith(tableName + ":")) continue;
                    return String.valueOf(object);
                }
            }
        }
        return null;
    }

    public String toString() {
        SerializeConfig tamsSerializeConfig = SerializeConfig.getGlobalInstance();
        tamsSerializeConfig.put(DataTypes.class, (ObjectSerializer)MappingEnumSerializer.instance);
        tamsSerializeConfig.put(Dynamic.class, (ObjectSerializer)MappingEnumSerializer.instance);
        return JSONObject.toJSONString((Object)this, (SerializeConfig)tamsSerializeConfig, (SerializerFeature[])new SerializerFeature[0]);
    }

    @ConstructorProperties(value={"properties", "dynamic", "enabled"})
    MappingBean(Map<String, Propertie> properties, Dynamic dynamic, Boolean enabled) {
        this.properties = properties;
        this.dynamic = dynamic;
        this.enabled = enabled;
    }

    public static MappingBeanBuilder builder() {
        return new MappingBeanBuilder();
    }

    public Map<String, Propertie> getProperties() {
        return this.properties;
    }

    public Dynamic getDynamic() {
        return this.dynamic;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public static class MappingBeanBuilder {
        private Map<String, Propertie> properties;
        private Dynamic dynamic;
        private Boolean enabled;

        MappingBeanBuilder() {
        }

        public MappingBeanBuilder properties(Map<String, Propertie> properties) {
            this.properties = properties;
            return this;
        }

        public MappingBeanBuilder dynamic(Dynamic dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public MappingBeanBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public MappingBean build() {
            return new MappingBean(this.properties, this.dynamic, this.enabled);
        }

        public String toString() {
            return "MappingBean.MappingBeanBuilder(properties=" + this.properties + ", dynamic=" + (Object)((Object)this.dynamic) + ", enabled=" + this.enabled + ")";
        }
    }

    public static enum DataTypes {
        TEXT("text", new BinlogType[0], (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value) {
                return value;
            }
        }),
        KEYWORD("keyword", new BinlogType[]{BinlogType.VARCHAR, BinlogType.TIME, BinlogType.YEAR, BinlogType.TIME2, BinlogType.STRING}, (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value) {
                return value;
            }
        }),
        DATE("date", new BinlogType[]{BinlogType.TIMESTAMP, BinlogType.DATE, BinlogType.DATETIME, BinlogType.NEWDATE, BinlogType.TIMESTAMP2, BinlogType.DATETIME2}, (IConvertObj)new IConvertObj<Date>(){

            public Date getObj(String value) {
                Date objToDate = DateUtil.objToDate((Object)value);
                return objToDate;
            }
        }),
        LONG("long", new BinlogType[]{BinlogType.TINY, BinlogType.SHORT, BinlogType.LONG, BinlogType.LONGLONG, BinlogType.INT24, BinlogType.BIT, BinlogType.ENUM, BinlogType.SET}, (IConvertObj)new IConvertObj<Long>(){

            public Long getObj(String value) {
                Long retobj = StringUtil.isNull((Object)value) ? null : Long.valueOf(Long.parseLong(value));
                return retobj;
            }
        }),
        DOUBLE("double", new BinlogType[]{BinlogType.FLOAT, BinlogType.DOUBLE, BinlogType.DECIMAL, BinlogType.NEWDECIMAL}, (IConvertObj)new IConvertObj<Double>(){

            public Double getObj(String value) {
                Double retobj = StringUtil.isNull((Object)value) ? null : Double.valueOf(Double.parseDouble(value));
                return retobj;
            }
        }),
        BOOLEAN("boolean", new BinlogType[0], (IConvertObj)new IConvertObj<Boolean>(){

            public Boolean getObj(String value) {
                return StringUtil.isNull((Object)value) ? null : Boolean.valueOf(Boolean.parseBoolean(value));
            }
        }),
        IP("ip", new BinlogType[0], (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value) {
                return value;
            }
        }),
        OBJECT("object", new BinlogType[]{BinlogType.JSON}, (IConvertObj)new IConvertObj<Object>(){

            public Object getObj(String value) {
                throw new RuntimeException("\u6682\u4e0d\u652f\u6301");
            }
        }),
        NESTED("nested", new BinlogType[0], (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value) {
                return value;
            }
        }),
        GEO_POINT("geo_point", new BinlogType[0], (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value) {
                return value;
            }
        }),
        GEO_SHAPE("geo_shape", new BinlogType[0], (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value) {
                return value;
            }
        }),
        JOIN("join", new BinlogType[0], (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value) {
                return value;
            }
        }),
        COMPLETION("completion", new BinlogType[0], (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value) {
                return value;
            }
        });

        private final String value;
        private final IConvertObj convertObj;
        private final BinlogType[] BinlogTypes;

        public BinlogType[] getBinlogTypes() {
            return this.BinlogTypes;
        }

        private DataTypes(String value, BinlogType[] BinlogTypes, IConvertObj convertObj) {
            this.value = value;
            this.BinlogTypes = BinlogTypes;
            this.convertObj = convertObj;
        }

        public String getValue() {
            return this.value;
        }

        public Object getConvertObj(String value) {
            return this.convertObj.getObj(value);
        }

        public static DataTypes getDataTypeByName(String name) {
            if (StringUtil.isNull((Object)name)) {
                return null;
            }
            for (DataTypes dataTypes : DataTypes.values()) {
                if (!dataTypes.getValue().equalsIgnoreCase(name)) continue;
                return dataTypes;
            }
            return null;
        }

        public static DataTypes getDataTypeByName(JSONObject filedObj) {
            String type = filedObj.getString("type");
            filedObj.remove((Object)"type");
            return DataTypes.getDataTypeByName(type);
        }

        public static DataTypes getDataTypesByMysqlType(BinlogType mysqlType) {
            if (mysqlType == null) {
                return null;
            }
            for (DataTypes dataTypes : DataTypes.values()) {
                if (!ArrayUtils.contains((Object[])dataTypes.getBinlogTypes(), (Object)mysqlType)) continue;
                return dataTypes;
            }
            return null;
        }
    }

    public static enum Dynamic {
        TRUE("true"),
        FALSE("false"),
        STRICT("strict");

        private final String value;

        private Dynamic(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Propertie {
        private Map<String, Propertie> properties;
        private DataTypes type;
        private Boolean enabled;
        private JSONObject relations;
        private String ignore_above;

        public Map<String, Propertie> getProperties() {
            return this.properties;
        }

        public DataTypes getType() {
            return this.type;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public JSONObject getRelations() {
            return this.relations;
        }

        public String getIgnore_above() {
            return this.ignore_above;
        }

        public void setProperties(Map<String, Propertie> properties) {
            this.properties = properties;
        }

        public void setType(DataTypes type) {
            this.type = type;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public void setRelations(JSONObject relations) {
            this.relations = relations;
        }

        public void setIgnore_above(String ignore_above) {
            this.ignore_above = ignore_above;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Propertie)) {
                return false;
            }
            Propertie other = (Propertie)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Propertie> this$properties = this.getProperties();
            Map<String, Propertie> other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                return false;
            }
            DataTypes this$type = this.getType();
            DataTypes other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            JSONObject this$relations = this.getRelations();
            JSONObject other$relations = other.getRelations();
            if (this$relations == null ? other$relations != null : !this$relations.equals(other$relations)) {
                return false;
            }
            String this$ignore_above = this.getIgnore_above();
            String other$ignore_above = other.getIgnore_above();
            return !(this$ignore_above == null ? other$ignore_above != null : !this$ignore_above.equals(other$ignore_above));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Propertie;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Propertie> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            DataTypes $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            JSONObject $relations = this.getRelations();
            result = result * 59 + ($relations == null ? 43 : $relations.hashCode());
            String $ignore_above = this.getIgnore_above();
            result = result * 59 + ($ignore_above == null ? 43 : $ignore_above.hashCode());
            return result;
        }

        public String toString() {
            return "MappingBean.Propertie(properties=" + this.getProperties() + ", type=" + (Object)((Object)this.getType()) + ", enabled=" + this.getEnabled() + ", relations=" + this.getRelations() + ", ignore_above=" + this.getIgnore_above() + ")";
        }
    }
}

