package net.wicp.tams.common.es.bean;

import java.util.ArrayList;
import java.util.List;

import lombok.Builder;
import lombok.Data;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.SimpleTreeNode;

/***
 * 创建索引用的辅助bean
 * 
 * @author andy.zhou
 *
 */
@Data
@Builder
public class IndexParamsBean {
	private String db;
	private String tb;
	// private String primary;
	// 第一个从表
	private String db1;
	private String tb1;
	private String rela1;

	public List<SimpleTreeNode> buildRelaNodes() {
		if (StringUtil.isNull(rela1)) {
			return null;
		}
		List<SimpleTreeNode> retlist = new ArrayList<>();
		SimpleTreeNode node = new SimpleTreeNode(tb, null);
		String subrela = String.format("%s:%s", tb1, rela1);
		SimpleTreeNode node2 = new SimpleTreeNode(subrela, tb);
		retlist.add(node);
		retlist.add(node2);
		return retlist;
	}
}
