/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.es.bean;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.apiext.DateUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertObj;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.es.MappingEnumSerializer;
import org.apache.commons.lang3.ArrayUtils;

public class MappingBean {
    private Map<String, Propertie> properties;
    private Dynamic dynamic;
    private Boolean enabled;
    @JSONField(name="_routing")
    private Routing routing;
    @JSONField(name="_parent")
    private Parent parent;
    @JSONField(serialize=false)
    private String type;

    public static MappingBean proMappingBean(Boolean canIndex, String type, String jsonstr, String parent) {
        MappingBeanBuilder builder = MappingBean.builder().dynamic(Dynamic.STRICT).enabled(canIndex == null ? true : canIndex);
        JSONObject parseObject1 = JSON.parseObject((String)jsonstr);
        HashMap<String, Propertie> properties1 = new HashMap<String, Propertie>();
        for (String key : parseObject1.keySet()) {
            Propertie propertieBuilder = new Propertie();
            DataTypes dataType = DataTypes.getDataTypeByName(parseObject1.getString(key));
            if (dataType == null) {
                throw new RuntimeException("\u9519\u8bef\u7684mapping\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5key:[" + key + "]\u7684\u7c7b\u578b");
            }
            propertieBuilder.setType(dataType);
            properties1.put(key, propertieBuilder);
        }
        builder.properties(properties1);
        builder.type(type);
        if (StringUtil.isNotNull((Object)parent)) {
            Routing routing = new Routing();
            routing.setRequired(true);
            builder.routing(routing);
            Parent parentNode = new Parent();
            parentNode.setType(parent);
            builder.parent(parentNode);
        }
        return builder.build();
    }

    public static MappingBean proMappingBean(String type, String jsonstr, String parent) {
        return MappingBean.proMappingBean(true, type, jsonstr, parent);
    }

    public String toString() {
        SerializeConfig tamsSerializeConfig = SerializeConfig.getGlobalInstance();
        tamsSerializeConfig.put(DataTypes.class, (ObjectSerializer)MappingEnumSerializer.instance);
        tamsSerializeConfig.put(Dynamic.class, (ObjectSerializer)MappingEnumSerializer.instance);
        return JSONObject.toJSONString((Object)this, (SerializeConfig)tamsSerializeConfig, (SerializerFeature[])new SerializerFeature[0]);
    }

    @ConstructorProperties(value={"properties", "dynamic", "enabled", "routing", "parent", "type"})
    MappingBean(Map<String, Propertie> properties, Dynamic dynamic, Boolean enabled, Routing routing, Parent parent, String type) {
        this.properties = properties;
        this.dynamic = dynamic;
        this.enabled = enabled;
        this.routing = routing;
        this.parent = parent;
        this.type = type;
    }

    public static MappingBeanBuilder builder() {
        return new MappingBeanBuilder();
    }

    public Map<String, Propertie> getProperties() {
        return this.properties;
    }

    public Dynamic getDynamic() {
        return this.dynamic;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Routing getRouting() {
        return this.routing;
    }

    public Parent getParent() {
        return this.parent;
    }

    public String getType() {
        return this.type;
    }

    public static class MappingBeanBuilder {
        private Map<String, Propertie> properties;
        private Dynamic dynamic;
        private Boolean enabled;
        private Routing routing;
        private Parent parent;
        private String type;

        MappingBeanBuilder() {
        }

        public MappingBeanBuilder properties(Map<String, Propertie> properties) {
            this.properties = properties;
            return this;
        }

        public MappingBeanBuilder dynamic(Dynamic dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public MappingBeanBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public MappingBeanBuilder routing(Routing routing) {
            this.routing = routing;
            return this;
        }

        public MappingBeanBuilder parent(Parent parent) {
            this.parent = parent;
            return this;
        }

        public MappingBeanBuilder type(String type) {
            this.type = type;
            return this;
        }

        public MappingBean build() {
            return new MappingBean(this.properties, this.dynamic, this.enabled, this.routing, this.parent, this.type);
        }

        public String toString() {
            return "MappingBean.MappingBeanBuilder(properties=" + this.properties + ", dynamic=" + (Object)((Object)this.dynamic) + ", enabled=" + this.enabled + ", routing=" + this.routing + ", parent=" + this.parent + ", type=" + this.type + ")";
        }
    }

    public static enum DataTypes {
        TEXT("text", new BinlogType[0], (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value, String formate) {
                return value;
            }
        }),
        KEYWORD("keyword", new BinlogType[]{BinlogType.VARCHAR, BinlogType.TIME, BinlogType.YEAR, BinlogType.TIME2, BinlogType.STRING}, (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value, String formate) {
                return value;
            }
        }),
        DATE("date", new BinlogType[]{BinlogType.TIMESTAMP, BinlogType.DATE, BinlogType.DATETIME, BinlogType.NEWDATE, BinlogType.TIMESTAMP2, BinlogType.DATETIME2}, (IConvertObj)new IConvertObj<Serializable>(){
            Map<String, String> formatmap = new HashMap<String, String>();
            {
                this.formatmap.put("date_time", "yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
                this.formatmap.put("strict_date_time", "yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
                this.formatmap.put("date_time_no_millis", "yyyy-MM-dd'T'HH:mm:ssZZ");
            }

            public Serializable getObj(String value, String formate) {
                Date objToDate = DateUtil.objToDate((Object)value);
                if (StringUtil.isNull((Object)formate)) {
                    return objToDate;
                }
                String formatStr = StringUtil.hasNull((String[])new String[]{this.formatmap.get(formate), "yyyy-MM-dd'T'HH:mm:ss.SSSZZ"});
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatStr);
                return simpleDateFormat.format(objToDate);
            }
        }),
        LONG("long", new BinlogType[]{BinlogType.TINY, BinlogType.SHORT, BinlogType.LONG, BinlogType.LONGLONG, BinlogType.INT24, BinlogType.BIT, BinlogType.ENUM, BinlogType.SET}, (IConvertObj)new IConvertObj<Long>(){

            public Long getObj(String value, String formate) {
                Long retobj = StringUtil.isNull((Object)value) ? null : Long.valueOf(Long.parseLong(value));
                return retobj;
            }
        }),
        DOUBLE("double", new BinlogType[]{BinlogType.FLOAT, BinlogType.DOUBLE, BinlogType.DECIMAL, BinlogType.NEWDECIMAL}, (IConvertObj)new IConvertObj<Double>(){

            public Double getObj(String value, String formate) {
                Double retobj = StringUtil.isNull((Object)value) ? null : Double.valueOf(Double.parseDouble(value));
                return retobj;
            }
        }),
        BOOLEAN("boolean", new BinlogType[0], (IConvertObj)new IConvertObj<Boolean>(){

            public Boolean getObj(String value, String formate) {
                return StringUtil.isNull((Object)value) ? null : Boolean.valueOf(Boolean.parseBoolean(value));
            }
        }),
        IP("ip", new BinlogType[0], (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value, String formate) {
                return value;
            }
        }),
        OBJECT("object", new BinlogType[]{BinlogType.JSON}, (IConvertObj)new IConvertObj<Object>(){

            public Object getObj(String value, String formate) {
                throw new RuntimeException("\u6682\u4e0d\u652f\u6301");
            }
        }),
        NESTED("nested", new BinlogType[0], (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value, String formate) {
                return value;
            }
        }),
        GEO_POINT("geo_point", new BinlogType[0], (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value, String formate) {
                return value;
            }
        }),
        GEO_SHAPE("geo_shape", new BinlogType[0], (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value, String formate) {
                return value;
            }
        }),
        JOIN("join", new BinlogType[0], (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value, String formate) {
                return value;
            }
        }),
        COMPLETION("completion", new BinlogType[0], (IConvertObj)new IConvertObj<String>(){

            public String getObj(String value, String formate) {
                return value;
            }
        });

        private final String value;
        private final IConvertObj convertObj;
        private final BinlogType[] BinlogTypes;

        public BinlogType[] getBinlogTypes() {
            return this.BinlogTypes;
        }

        private DataTypes(String value, BinlogType[] BinlogTypes, IConvertObj convertObj) {
            this.value = value;
            this.BinlogTypes = BinlogTypes;
            this.convertObj = convertObj;
        }

        public String getValue() {
            return this.value;
        }

        public Object getConvertObj(String value, String formate) {
            return this.convertObj.getObj(value, formate);
        }

        public static DataTypes getDataTypeByName(String name) {
            if (StringUtil.isNull((Object)name)) {
                return null;
            }
            for (DataTypes dataTypes : DataTypes.values()) {
                if (!dataTypes.getValue().equalsIgnoreCase(name)) continue;
                return dataTypes;
            }
            return null;
        }

        public static DataTypes getDataTypeByName(JSONObject filedObj) {
            String type = filedObj.getString("type");
            filedObj.remove((Object)"type");
            return DataTypes.getDataTypeByName(type);
        }

        public static DataTypes getDataTypesByMysqlType(BinlogType mysqlType) {
            if (mysqlType == null) {
                return null;
            }
            for (DataTypes dataTypes : DataTypes.values()) {
                if (!ArrayUtils.contains((Object[])dataTypes.getBinlogTypes(), (Object)mysqlType)) continue;
                return dataTypes;
            }
            return null;
        }
    }

    public static enum Dynamic {
        TRUE("true"),
        FALSE("false"),
        STRICT("strict");

        private final String value;

        private Dynamic(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Propertie {
        private Map<String, Propertie> properties;
        private DataTypes type;
        private Boolean enabled;
        private String ignore_above;

        public Map<String, Propertie> getProperties() {
            return this.properties;
        }

        public DataTypes getType() {
            return this.type;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public String getIgnore_above() {
            return this.ignore_above;
        }

        public void setProperties(Map<String, Propertie> properties) {
            this.properties = properties;
        }

        public void setType(DataTypes type) {
            this.type = type;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public void setIgnore_above(String ignore_above) {
            this.ignore_above = ignore_above;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Propertie)) {
                return false;
            }
            Propertie other = (Propertie)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Propertie> this$properties = this.getProperties();
            Map<String, Propertie> other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                return false;
            }
            DataTypes this$type = this.getType();
            DataTypes other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            String this$ignore_above = this.getIgnore_above();
            String other$ignore_above = other.getIgnore_above();
            return !(this$ignore_above == null ? other$ignore_above != null : !this$ignore_above.equals(other$ignore_above));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Propertie;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Propertie> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            DataTypes $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            String $ignore_above = this.getIgnore_above();
            result = result * 59 + ($ignore_above == null ? 43 : $ignore_above.hashCode());
            return result;
        }

        public String toString() {
            return "MappingBean.Propertie(properties=" + this.getProperties() + ", type=" + (Object)((Object)this.getType()) + ", enabled=" + this.getEnabled() + ", ignore_above=" + this.getIgnore_above() + ")";
        }
    }

    public static class Parent {
        private String type;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parent)) {
                return false;
            }
            Parent other = (Parent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "MappingBean.Parent(type=" + this.getType() + ")";
        }
    }

    public static class Routing {
        private boolean required;

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Routing)) {
                return false;
            }
            Routing other = (Routing)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isRequired() == other.isRequired();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Routing;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRequired() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "MappingBean.Routing(required=" + this.isRequired() + ")";
        }
    }
}

