package net.wicp.tams.common.es.bean;

import com.alibaba.fastjson.JSONObject;

import lombok.Builder;
import lombok.Data;

/***
 * 创建索引用的辅助bean
 * 
 * @author andy.zhou
 *
 */
@Data
@Builder
public class IndexParamsBean {
	private String db;
	private String tb;
	// private String primary;
	// 第一个从表
	private String db1;
	private String tb1;
	private String rela1;
	// 默认15分片
	@Builder.Default
	private int shardsNum = 15;

	public static IndexParamsBean buildJson(String jsonstr) {
		JSONObject parObj = JSONObject.parseObject(jsonstr);
		IndexParamsBeanBuilder retobj = IndexParamsBean.builder();
		if (parObj.containsKey("db")) {
			retobj.db(parObj.getString("db"));
		}
		if (parObj.containsKey("tb")) {
			retobj.tb(parObj.getString("tb"));
		}
		if (parObj.containsKey("db1")) {
			retobj.db1(parObj.getString("db1"));
		}
		if (parObj.containsKey("tb1")) {
			retobj.tb1(parObj.getString("tb1"));
		}
		if (parObj.containsKey("rela1")) {
			retobj.rela1(parObj.getString("rela1"));
		}
		if (parObj.containsKey("shardsNum")) {
			retobj.shardsNum(parObj.getIntValue("shardsNum"));
		}
		return retobj.build();
	}
}
