package net.wicp.tams.common.es.constant;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public enum ClusterSettings {
	store_throttle_type("合并的阈值", "indices.store.throttle.type", Type.TRANSIENT, new String[] { "merge", "not", "all" });// TODO
																														// 6.2没有这个参数

	private final String desc;
	private final String key;
	private final Type type;
	private final String[] values;

	private ClusterSettings(String desc, String key, Type type, String[] values) {
		this.desc = desc;
		this.key = key;
		this.type = type;
		this.values = values;
	}

	public static enum Type {
		PERSISTENT, TRANSIENT;
	}

	public String getDesc() {
		return desc;
	}

	public Type getType() {
		return type;
	}

	public String getKey() {
		return key;
	}

	public String[] getValues() {
		return values;
	}

	public void valid(String value) {
		Validate.notBlank(value);
		if (ArrayUtils.isEmpty(values)) {
			return;
		}
		Validate.isTrue(ArrayUtils.contains(values, value));
	}

}
