/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.doris.constant;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import net.wicp.tams.common.doris.bean.DorisConfig;
import net.wicp.tams.common.doris.bean.RespContent;
import net.wicp.tams.common.doris.exception.StreamLoadException;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class DorisStreamLoad
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(DorisStreamLoad.class);
    private static final long serialVersionUID = 1L;
    private final List<String> DORIS_SUCCESS_STATUS = new ArrayList<String>(Arrays.asList("Success", "Publish Timeout"));
    private final String loadUrlPattern = "http://%s/api/%s/%s/_stream_load?";
    private final String charset = "UTF-8";
    private final DorisConfig dorisConfig;
    private final String authEncoding;
    private static final HttpClientBuilder httpClientBuilder = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

        protected boolean isRedirectable(String method) {
            return true;
        }
    });

    public DorisStreamLoad(DorisConfig dorisConfig) {
        this.dorisConfig = dorisConfig;
        this.authEncoding = Base64.getEncoder().encodeToString(String.format("%s:%s", dorisConfig.getUsername(), dorisConfig.getPassword()).getBytes(StandardCharsets.UTF_8));
    }

    private String getLoadUrlStr() {
        String loadUrl = String.format("http://%s/api/%s/%s/_stream_load?", this.dorisConfig.getHost() + ":" + this.dorisConfig.getHttpPort(), this.dorisConfig.getDb(), this.dorisConfig.getTb());
        return loadUrl;
    }

    private String getLoadUrlStr(String db, String tb) {
        this.dorisConfig.setDb(db);
        this.dorisConfig.setTb(tb);
        String loadUrl = String.format(this.loadUrlPattern, this.dorisConfig.getHost() + ":" + this.dorisConfig.getHttpPort(), db, tb);
        return loadUrl;
    }

    public void loadJsonArrayAppend(String jsonData) throws Exception {
        this.loadJsonArray(jsonData, this.getHttpPutJsonArrayAppend());
    }

    public void loadJsonArrayAppend(String jsonData, String db, String tb) throws Exception {
        this.loadJsonArray(jsonData, this.getHttpPutJsonArrayAppend(db, tb));
    }

    public void loadJsonArrayDelete(String jsonData) throws Exception {
        this.loadJsonArray(jsonData, this.getHttpPutJsonArrayDelete());
    }

    public void loadJsonArrayDelete(String jsonData, String db, String tb) throws Exception {
        this.loadJsonArray(jsonData, this.getHttpPutJsonArrayDelete(db, tb));
    }

    private void loadJsonArray(String jsonData, HttpPut put) throws Exception {
        CloseableHttpClient client = httpClientBuilder.build();
        StringEntity entity = new StringEntity(jsonData, "UTF-8");
        put.setEntity((HttpEntity)entity);
        try {
            log.info("streamTimeCountStart");
            StopWatch sw = new StopWatch();
            sw.start("streamTimeCount");
            CloseableHttpResponse response = client.execute((HttpUriRequest)put);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException(String.format("Stream load failed. status: %s load result: %s", statusCode, response.getStatusLine().getReasonPhrase()));
            }
            sw.stop();
            log.info(sw.getLastTaskName() + ":" + sw.getTotalTimeMillis());
            log.info(sw.getLastTaskName() + ":" + sw.getTotalTimeSeconds());
            this.generateRespContent(response);
        }
        catch (Exception e) {
            throw new StreamLoadException(e);
        }
        finally {
            client.close();
        }
    }

    private RespContent generateRespContent(CloseableHttpResponse response) throws StreamLoadException {
        ObjectMapper obj = new ObjectMapper();
        String loadResponse = "";
        RespContent respContent = new RespContent();
        try {
            loadResponse = EntityUtils.toString((HttpEntity)response.getEntity());
            respContent = (RespContent)obj.readValue(loadResponse, RespContent.class);
            if (!this.DORIS_SUCCESS_STATUS.contains(respContent.getStatus())) {
                log.error("stream load error: " + respContent.getMessage());
                throw new StreamLoadException("stream load error: " + respContent.getMessage());
            }
        }
        catch (IOException | StreamLoadException e) {
            log.error(" streamload response3 hostport:" + this.dorisConfig.getHost() + ":" + this.dorisConfig.getHttpPort() + " " + this.dorisConfig.getDb() + "." + this.dorisConfig.getTb() + " " + loadResponse, (Throwable)e);
            throw new StreamLoadException(e);
        }
        log.info("\u5199\u5165\u6210\u529f,result{}", (Object)JSON.toJSONString((Object)respContent.toString()));
        return respContent;
    }

    private String basicAuthHeader(String username, String password) {
        String tobeEncode = username + ":" + password;
        byte[] encoded = org.apache.commons.codec.binary.Base64.encodeBase64((byte[])tobeEncode.getBytes(StandardCharsets.UTF_8));
        return "Basic " + new String(encoded);
    }

    private HttpPut getHttpPutJsonArrayAppend() {
        HttpPut put = new HttpPut(this.getLoadUrlStr());
        put.removeHeaders("Content-Length");
        put.removeHeaders("Transfer-Encoding");
        put.setHeader("Expect", "100-continue");
        put.setHeader("Authorization", this.basicAuthHeader(this.dorisConfig.getUsername(), this.dorisConfig.getPassword()));
        put.setHeader("label", UUID.randomUUID().toString());
        put.setHeader("column_separator", ",");
        put.setHeader("format", "json");
        put.setHeader("strip_outer_array", "true");
        put.setHeader("merge_type", "APPEND");
        put.setHeader("timeout", this.dorisConfig.getTimeout());
        return put;
    }

    private HttpPut getHttpPutJsonArrayAppend(String db, String tb) {
        HttpPut put = new HttpPut(this.getLoadUrlStr(db, tb));
        put.removeHeaders("Content-Length");
        put.removeHeaders("Transfer-Encoding");
        put.setHeader("Expect", "100-continue");
        put.setHeader("Authorization", this.basicAuthHeader(this.dorisConfig.getUsername(), this.dorisConfig.getPassword()));
        put.setHeader("label", UUID.randomUUID().toString());
        put.setHeader("column_separator", ",");
        put.setHeader("format", "json");
        put.setHeader("strip_outer_array", "true");
        put.setHeader("merge_type", "APPEND");
        put.setHeader("timeout", this.dorisConfig.getTimeout());
        return put;
    }

    private HttpPut getHttpPutJsonArrayDelete(String db, String tb) {
        HttpPut put = new HttpPut(this.getLoadUrlStr(db, tb));
        put.removeHeaders("Content-Length");
        put.removeHeaders("Transfer-Encoding");
        put.setHeader("Expect", "100-continue");
        put.setHeader("Authorization", this.basicAuthHeader(this.dorisConfig.getUsername(), this.dorisConfig.getPassword()));
        put.setHeader("label", UUID.randomUUID().toString());
        put.setHeader("column_separator", ",");
        put.setHeader("format", "json");
        put.setHeader("strip_outer_array", "true");
        put.setHeader("merge_type", "DELETE");
        put.setHeader("timeout", this.dorisConfig.getTimeout());
        return put;
    }

    private HttpPut getHttpPutJsonArrayDelete() {
        HttpPut put = new HttpPut(this.getLoadUrlStr());
        put.removeHeaders("Content-Length");
        put.removeHeaders("Transfer-Encoding");
        put.setHeader("Expect", "100-continue");
        put.setHeader("Authorization", this.basicAuthHeader(this.dorisConfig.getUsername(), this.dorisConfig.getPassword()));
        put.setHeader("label", UUID.randomUUID().toString());
        put.setHeader("column_separator", ",");
        put.setHeader("format", "json");
        put.setHeader("strip_outer_array", "true");
        put.setHeader("merge_type", "DELETE");
        put.setHeader("timeout", this.dorisConfig.getTimeout());
        return put;
    }
}

