/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.doris.constant;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.wicp.tams.common.doris.bean.DorisConfig;
import net.wicp.tams.common.doris.constant.DorisStreamLoadBe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisSink {
    private static final Logger log = LoggerFactory.getLogger(DorisSink.class);
    private static final String TB_FULLNAME_FORMATE = "%s`%s";
    private static final String TB_DATAKEY_FORMATE = "%s`%s`%s";
    private Long lastFlushTime = 0L;
    private Long flushCacheMillis = 180000L;
    private final ConcurrentHashMap<String, Map<String, Object>> cacheMap = new ConcurrentHashMap();
    private final DorisConfig dorisConfig;
    private final DorisStreamLoadBe dorisStreamLoadBe;

    public DorisSink(DorisConfig dorisConfig) {
        this.dorisConfig = dorisConfig;
        this.dorisStreamLoadBe = new DorisStreamLoadBe(dorisConfig);
        this.flushCacheMillis = dorisConfig.getFlushCacheSecond().longValue() * 1000L;
        this.lastFlushTime = System.currentTimeMillis();
    }

    public void sink(String db, String tb, String primaryKeyVales, Map<String, String> data) {
        String tbFullName = String.format(TB_FULLNAME_FORMATE, db, tb);
        String dataKey = String.format(TB_DATAKEY_FORMATE, db, tb, primaryKeyVales);
        Map<String, Object> tbData = this.cacheMap.get(tbFullName);
        if (tbData == null) {
            HashMap tbDataNew = Maps.newHashMap();
            tbDataNew.put(dataKey, data);
            this.cacheMap.put(tbFullName, tbDataNew);
        } else {
            tbData.put(dataKey, data);
            if (tbData.size() >= this.dorisConfig.getFlushCacheSize()) {
                log.info("\u8868\u6ee1\u5199\u5165\u5f00\u59cb time to flush cache,tbFullName={},tbSize={}", (Object)tbFullName, (Object)tbData.size());
                this.flush(tbFullName, db, tb);
                log.info("\u8868\u6ee1\u5199\u5165\u5b8c\u6210 time to flush cache,tbFullName={},tbSize={}", (Object)tbFullName, (Object)tbData.size());
            }
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastFlushTime >= this.flushCacheMillis) {
            log.info("\u8d85\u65f6\u5237\u7f13\u5b58 time to flush cache,\u8868\u6570\u91cf={}", (Object)this.cacheMap.size());
            this.flushCache();
            this.lastFlushTime = currentTime;
        }
    }

    private void flush(String tbKey, String db, String tb) {
        ObjectMapper objmap = new ObjectMapper();
        String data = objmap.valueToTree(this.cacheMap.get(tbKey).values()).toString();
        log.info("\u5199\u5165\u6570\u636e,tb={},size={}", (Object)tb, (Object)this.cacheMap.get(tbKey).values().size());
        try {
            this.dorisStreamLoadBe.loadJsonArrayAppend(data, db, tb);
            this.cacheMap.remove(tbKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void flushCache() {
        for (Map.Entry<String, Map<String, Object>> entry : this.cacheMap.entrySet()) {
            if (entry.getValue() == null) continue;
            log.info("flushCache,tb={},size={}", (Object)entry.getKey(), (Object)entry.getValue().size());
            this.flush(entry.getKey(), entry.getKey().split("`")[0], entry.getKey().split("`")[1]);
        }
    }
}

