/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.doris.plugin;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.util.StringUtils;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBinlogListener;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.doris.bean.CheckPointConfig;
import net.wicp.tams.common.doris.bean.DorisConfig;
import net.wicp.tams.common.doris.constant.DorisAssit;
import net.wicp.tams.common.doris.constant.DorisJdbcLoad;
import net.wicp.tams.common.doris.constant.DorisSinkV1;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

@Slf4j
public class ListenerDoris extends AbsBinlogListener {
	private final DorisConfig dorisConfig;
	private final CheckPointConfig chkConfig;
//	private final DorisStreamLoadBe dorisStreamLoad;
	private final DorisJdbcLoad dorisJdbcLoad;
//	private final DorisSink dorisSink;
	private final DorisSinkV1 dorisSink;

	public ListenerDoris() {
		this.dorisConfig = DorisAssit.initDefaultConfig();
		this.chkConfig = DorisAssit.initChkConfig();
//		this.dorisStreamLoad = new DorisStreamLoadBe(dorisConfig);
		this.dorisSink = new DorisSinkV1(dorisConfig, chkConfig);
		this.dorisJdbcLoad = new DorisJdbcLoad(dorisConfig, chkConfig);
	}

	@Override
	public void doInit(Rule rule, int index) {
	}

//	@Override
//	public void doBusiTrue(Rule rule, ListenerConf.DuckulaEvent duckulaEvent, Map<AddColName, Serializable> addValues,
//			boolean isSplit, boolean logicDel) {
//		for (int i = 0; i < duckulaEvent.getItemsCount(); i++) {
//			Map<String, String> valueMap = new HashMap<String, String>();
//			valueMap.putAll(DuckulaAssit.getValueMap(duckulaEvent, i));
//			if (MapUtils.isNotEmpty(addValues)) {
//				for (AddColName addColName : addValues.keySet()) {
//					valueMap.put(addColName.getColNameTrue(), String.valueOf(addValues.get(addColName)));
//				}
//			}
//			try {
//				dorisSink.sink(StringUtil.hasNull(duckulaEvent.getNewDb(), duckulaEvent.getDb()),
//						StringUtil.hasNull(duckulaEvent.getNewDb(), duckulaEvent.getTb()),
//						getKeyValues(duckulaEvent, valueMap), valueMap);
//			} catch (Exception e) {
//				throw new ProjectExceptionRuntime(ExceptAll.Project_default, e);
//			}
//
//		}
//	}

	@Override
	public void doBusiAsyncTrue(boolean isSplit, boolean logicDel,
			Map<Rule, List<Pair<DuckulaEvent, Map<AddColName, Serializable>>>> sendDataCase) {
		dorisSink.doBusiAsyncTrue(isSplit, logicDel, sendDataCase);
	}



	@Override
	public Result doAlterTableCallBack(Rule rule, ListenerConf.ColHis colHis, String sql, String[] addColNames,
			String updateColName, String[] deleteColNames, FieldFormart fieldFormart, String newDb, String newTb) {
		if ((addColNames != null && addColNames.length > 0) || !org.apache.commons.lang3.StringUtils.isEmpty(updateColName)) {
			try {
				dorisSink.flushCache();
			} catch (Exception e) {
				// 重置点位，重启
				throw new ProjectExceptionRuntime(ExceptAll.Project_default, e);
			}
			Boolean result = dorisJdbcLoad.alterTable(rule, colHis, addColNames, sql, newDb, newTb);
			if (!result) {
				throw new ProjectExceptionRuntime(ExceptAll.Project_default);
			}
			log.info("doris修改表结构成功！");
		}
		return Result.getSuc();
	}

}
