/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.doris.constant;

import com.google.common.collect.Lists;
import com.mysql.jdbc.exceptions.jdbc4.MySQLSyntaxErrorException;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;
import java.util.List;
import java.util.Map;

/**
 * doris jdbc load
 */
@Slf4j
public class DorisJdbcLoadTest {
    private static final String checkBatchDeleteColumn = "__DORIS_DELETE_SIGN__";


    public static DataSource prestoDataSource() {
        return DataSourceBuilder.create().url("jdbc:mysql://192.168.32.232:9030/test")
                .username("root")
                .password("ZDNhMjdmNzIxYTI2")
                .driverClassName("com.mysql.jdbc.Driver")
                .type(HikariDataSource.class)
                .build();
    }

    public static JdbcTemplate dorisJdbcTemplate(DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    public static void main(String[] args) {
        alterTable();
    }
    public static Boolean alterTable(){
        JdbcTemplate jdbcTemplate = dorisJdbcTemplate(prestoDataSource());
        Boolean alterResult = false;
        String sql = "ALTER TABLE `test`.`user_info` \n" +
                "ADD COLUMN `gender2` varchar(255) NULL COMMENT '性别' AFTER `create_time`;";
        List<String> cols = Lists.newArrayList("gender3");
        String db = "test";
        String tb = "user_info";
//        jdbcTemplate.execute(sql);
        String sqlCheck="DESC "+tb;
        while (true) {
            try {

                List<Map<String,Object>> list =jdbcTemplate.queryForList(sqlCheck);
                List<String> tableColumns = Lists.newArrayList();
                list.stream().forEach(stringObjectMap -> {
                    tableColumns.add(stringObjectMap.get("Field").toString());
                });
                if(tableColumns.containsAll(cols)){
                    alterResult = true;
                }

                if(!alterResult){
                    throw new ProjectExceptionRuntime(ExceptAll.Project_default);
                }
                break;
            } catch (Throwable e) {
                boolean reDoWait = TimeAssist.reDoWait("doris-alterTable", 3);
                if (reDoWait) {// 达到最大值就出
                    log.error("重试3次,未获取到修改表结构字段结果！");
                    break;
                } else {
                    continue;
                }
            }
        }
        return alterResult;
    }


    public void check(){
        JdbcTemplate jdbcTemplate = dorisJdbcTemplate(prestoDataSource());

        String sql="ALTER TABLE user ENABLE FEATURE 'BATCH_DELETE'";
        String sqlCheckBefore="SET show_hidden_columns=true;";
        String sqlCheck="desc user";
        try{
            jdbcTemplate.execute(sql);
        }catch (BadSqlGrammarException e){
            MySQLSyntaxErrorException me = (MySQLSyntaxErrorException)e.getCause();
            System.out.println(me.getCause());
        }

        jdbcTemplate.execute(sqlCheckBefore);
        List<Map<String,Object>> list =jdbcTemplate.queryForList(sqlCheck);
        Boolean tag = false;
        for(Map<String,Object> map : list){
            if(checkBatchDeleteColumn.equals(map.get("Field"))){
                System.out.println(map.get("Field"));
                tag = true;
                break;
            }
        }

        System.out.println(tag);
    }

}
