/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.doris.constant;

import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.doris.bean.CheckPointConfig;
import net.wicp.tams.common.doris.bean.DorisConfig;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectException;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.sql.DataSource;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * doris jdbc load
 */
@Slf4j
public class CheckpointService {

    private final String fieldDelimiter = ",";
    private static String DESC_DB_TB = "DESC %s.%s";
    private static String COLUMN_TYPE_FORMAT = "%s(%s)";
    private static CheckPointConfig checkPointConfig;
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;

    public CheckpointService(CheckPointConfig checkPointConfig) {
        this.checkPointConfig = checkPointConfig;
        if(!StringUtils.isEmpty(checkPointConfig.getHost())){
            this.dataSource = getDataSource(checkPointConfig.getDbName());
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        }
    }

    public DataSource getDataSource(String db) {
        StringBuilder url = new StringBuilder("");
        url.append("jdbc:mysql://");
        url.append(checkPointConfig.getHost()+":"+checkPointConfig.getPort());
        url.append("/");
        url.append(db);
        return DataSourceBuilder.create().url(url.toString())
                .username(checkPointConfig.getUser())
                .password(checkPointConfig.getPassword())
                .driverClassName("com.mysql.jdbc.Driver")
                .type(HikariDataSource.class)
                .build();
    }

    public void deleteChk(long timeStr){
        if(checkPointConfig.getHost() != null){
            StringBuilder sql= new StringBuilder("");
            sql.append(" delete from position where ");
            sql.append(" clintId = ").append("'").append(this.checkPointConfig.getClientId()).append("'");
            sql.append(" and serverIp = ").append("'").append(this.checkPointConfig.getServerHost()).append("'");
            sql.append(" and time >= ").append(timeStr).append(";");
            jdbcTemplate.execute(sql.toString());
        }
    }


    //    public static void main(String[] args) {
//        JdbcTemplate jdbcTemplate = dorisJdbcTemplate(prestoDataSource());
//
//        String sql="ALTER TABLE user ENABLE FEATURE 'BATCH_DELETE'";
//        String sqlCheckBefore="SET show_hidden_columns=true;";
//        String sqlCheck="desc user";
//        jdbcTemplate.execute(sqlCheckBefore);
//        List<Map<String,Object>> list =jdbcTemplate.queryForList(sqlCheck);
//        System.out.println(list);
//    }

}
