/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.doris.constant;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableChangeColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableModifyColumn;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlUtil {
    private static final Logger log = LoggerFactory.getLogger(SqlUtil.class);

    public static Map<String, SQLColumnDefinition> getColumnDefinitionMap(String sql) {
        HashMap map = Maps.newHashMap();
        List stmtList = SQLUtils.parseStatements((String)sql, (String)"mysql");
        try {
            SQLAlterTableStatement sqlStatement = (SQLAlterTableStatement)stmtList.get(0);
            List items = sqlStatement.getItems();
            for (SQLAlterTableItem item : items) {
                SQLAlterTableAddColumn temp;
                if (item instanceof SQLAlterTableAddColumn) {
                    temp = (SQLAlterTableAddColumn)item;
                    for (SQLColumnDefinition definition : temp.getColumns()) {
                        map.put(definition.getNameAsString().replaceAll("`", ""), definition);
                    }
                }
                if (!(item instanceof MySqlAlterTableChangeColumn)) continue;
                temp = (MySqlAlterTableChangeColumn)item;
                SQLColumnDefinition definition = temp.getNewColumnDefinition();
                map.put(definition.getNameAsString().replaceAll("`", ""), definition);
            }
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u65b0\u589e\u5b57\u6bb5\u5931\u8d25\uff1a" + sql, (Throwable)e);
        }
        return map;
    }

    public static Map<String, SQLColumnDefinition> getModifyColumnDefinitionMap(String sql) {
        HashMap map = Maps.newHashMap();
        List stmtList = SQLUtils.parseStatements((String)sql, (String)"mysql");
        try {
            SQLAlterTableStatement sqlStatement = (SQLAlterTableStatement)stmtList.get(0);
            List items = sqlStatement.getItems();
            for (SQLAlterTableItem item : items) {
                if (!(item instanceof MySqlAlterTableModifyColumn)) continue;
                MySqlAlterTableModifyColumn temp = (MySqlAlterTableModifyColumn)item;
                SQLColumnDefinition definition = temp.getNewColumnDefinition();
                map.put(definition.getNameAsString().replaceAll("`", ""), definition);
            }
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u4fee\u6539\u5b57\u6bb5\u5931\u8d25\uff1a" + sql, (Throwable)e);
        }
        return map;
    }
}

