/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.doris.constant;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import net.wicp.tams.common.doris.bean.RespContent;
import net.wicp.tams.common.doris.constant.DorisStreamLoad;
import net.wicp.tams.common.doris.exception.StreamLoadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisStreamLoadBe1
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DorisStreamLoad.class);
    private static final List<String> DORIS_SUCCESS_STATUS = new ArrayList<String>(Arrays.asList("Success", "Publish Timeout"));
    private static final String loadUrlPattern = "http://%s/api/%s/%s/_stream_load?";
    private final String user;
    private final String passwd;
    private String loadUrlStr;
    private String hostPort;
    private final String db;
    private final String tbl;
    private final String authEncoding;
    private final String jobName;

    public DorisStreamLoadBe1(String hostPort, String db, String tbl, String user, String passwd, String jobName) {
        this.hostPort = hostPort;
        this.db = db;
        this.tbl = tbl;
        this.user = user;
        this.passwd = passwd;
        this.jobName = jobName;
        this.loadUrlStr = String.format(loadUrlPattern, hostPort, db, tbl);
        this.authEncoding = Base64.getEncoder().encodeToString(String.format("%s:%s", user, passwd).getBytes(StandardCharsets.UTF_8));
    }

    public String getLoadUrlStr() {
        return this.loadUrlStr;
    }

    public String getHostPort() {
        return this.hostPort;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
        this.loadUrlStr = String.format(loadUrlPattern, hostPort, this.db, this.tbl);
    }

    private HttpURLConnection getConnection(String urlStr, String label) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod("PUT");
        String authEncoding = Base64.getEncoder().encodeToString(String.format("%s:%s", this.user, this.passwd).getBytes(StandardCharsets.UTF_8));
        conn.setRequestProperty("Authorization", "Basic " + authEncoding);
        conn.addRequestProperty("Expect", "100-continue");
        conn.addRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        conn.addRequestProperty("label", label);
        conn.addRequestProperty("column_separator", ",");
        conn.addRequestProperty("format", "json");
        conn.addRequestProperty("strip_outer_array", "true");
        conn.addRequestProperty("merge_type", "APPEND");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        return conn;
    }

    public void load(String value) throws StreamLoadException {
        LoadResponse loadResponse = this.loadBatch(value);
        if (loadResponse.status != 200) {
            System.out.println(this.getJobName() + " streamload response1 hostport:" + this.hostPort + " " + this.db + "." + this.tbl + " " + loadResponse);
            throw new StreamLoadException("stream load error: " + loadResponse.respContent);
        }
        ObjectMapper obj = new ObjectMapper();
        try {
            RespContent respContent = (RespContent)obj.readValue(loadResponse.respContent, RespContent.class);
            if (!DORIS_SUCCESS_STATUS.contains(respContent.getStatus())) {
                System.out.println(this.getJobName() + " streamload response2 hostport:" + this.hostPort + " " + this.db + "." + this.tbl + " " + loadResponse);
                throw new StreamLoadException("stream load error: " + respContent.getMessage());
            }
        }
        catch (IOException e) {
            System.out.println(this.getJobName() + " streamload response3 hostport:" + this.hostPort + " " + this.db + "." + this.tbl + " " + loadResponse);
            throw new StreamLoadException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadResponse loadBatch(String value) {
        Calendar calendar = Calendar.getInstance();
        String label = String.format("audit_%s%02d%02d_%02d%02d%02d_%s", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), UUID.randomUUID().toString().replaceAll("-", ""));
        HttpURLConnection feConn = null;
        HttpURLConnection beConn = null;
        try {
            String line;
            beConn = this.getConnection(this.loadUrlStr, label);
            BufferedOutputStream bos = new BufferedOutputStream(beConn.getOutputStream());
            bos.write(value.getBytes());
            bos.close();
            int status = beConn.getResponseCode();
            String respMsg = beConn.getResponseMessage();
            InputStream stream = (InputStream)beConn.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(stream));
            StringBuilder response = new StringBuilder();
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
            LoadResponse loadResponse = new LoadResponse(status, respMsg, response.toString());
            return loadResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            String err = "failed to load audit via AuditLoader plugin with label: " + label;
            LOG.warn(err, (Throwable)e);
            LoadResponse loadResponse = new LoadResponse(-1, e.getMessage(), err);
            return loadResponse;
        }
        finally {
            if (feConn != null) {
                feConn.disconnect();
            }
            if (beConn != null) {
                beConn.disconnect();
            }
        }
    }

    public static class LoadResponse {
        public int status;
        public String respMsg;
        public String respContent;

        public LoadResponse(int status, String respMsg, String respContent) {
            this.status = status;
            this.respMsg = respMsg;
            this.respContent = respContent;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("status: ").append(this.status);
            sb.append(", resp msg: ").append(this.respMsg);
            sb.append(", resp content: ").append(this.respContent);
            return sb.toString();
        }
    }
}

