/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.doris.constant;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.doris.bean.CheckPointConfig;
import net.wicp.tams.common.doris.bean.DorisConfig;

public abstract class DorisAssit {
    public static String getConfigValue(String confName) {
        String conf = Conf.get((String)String.format("common.doris.server.%s", confName));
        if ("default".equalsIgnoreCase(confName) || StringUtil.isNull((Object)conf)) {
            conf = Conf.get((String)String.format("common.doris.server.%s.%s", "default", confName));
        }
        return conf;
    }

    public static DorisConfig initDefaultConfig() {
        DorisConfig config = new DorisConfig();
        config.setHost(DorisAssit.getConfigValue("host"));
        config.setHostsBe(DorisAssit.getConfigValue("hostsBe"));
        config.setUsername(DorisAssit.getConfigValue("username"));
        config.setPassword(DorisAssit.getConfigValue("password"));
        config.setDb(DorisAssit.getConfigValue("db"));
        config.setTb(DorisAssit.getConfigValue("tb"));
        config.setHttpPort(DorisAssit.getConfigValue("httpPort"));
        config.setHttpPortBe(DorisAssit.getConfigValue("httpPortBe"));
        config.setJdbcPort(DorisAssit.getConfigValue("jdbcPort"));
        config.setTimeout(DorisAssit.getConfigValue("timeout"));
        config.setSqlRetryTimes(Integer.parseInt(DorisAssit.getConfigValue("sqlRetryTimes")));
        config.setFlushCacheSize(Integer.parseInt(DorisAssit.getConfigValue("flushCacheSize")));
        config.setFlushCacheSecond(Integer.parseInt(DorisAssit.getConfigValue("flushCacheSecond")));
        return config;
    }

    public static String getGConfValue(String confName) {
        String conf = Conf.get((String)String.format("common.binlog.alone.binlog.global.conf.%s", confName));
        if ("default".equalsIgnoreCase(confName) || StringUtil.isNull((Object)conf)) {
            conf = Conf.get((String)String.format("common.binlog.alone.binlog.global.conf.%s.%s", "default", confName));
        }
        return conf;
    }

    public static String getChkValue(String confName) {
        String conf = Conf.get((String)String.format("common.binlog.alone.binlog.global.chk.mysql.%s", confName));
        if ("default".equalsIgnoreCase(confName) || StringUtil.isNull((Object)conf)) {
            conf = Conf.get((String)String.format("common.binlog.alone.binlog.global.chk.mysql.%s.%s", "default", confName));
        }
        return conf;
    }

    public static String getGlobalValue(String confName) {
        String conf = Conf.get((String)String.format("common.binlog.alone.binlog.global.conf.%s", confName));
        if ("default".equalsIgnoreCase(confName) || StringUtil.isNull((Object)conf)) {
            conf = Conf.get((String)String.format("common.binlog.alone.binlog.global.conf.%s.%s", "default", confName));
        }
        return conf;
    }

    public static CheckPointConfig initChkConfig() {
        CheckPointConfig chkConfig = new CheckPointConfig();
        chkConfig.setHost(DorisAssit.getChkValue("host"));
        chkConfig.setPort(DorisAssit.getChkValue("port"));
        chkConfig.setDbName(DorisAssit.getChkValue("defaultdb"));
        chkConfig.setUser(DorisAssit.getChkValue("username"));
        chkConfig.setPassword(DorisAssit.getChkValue("password"));
        chkConfig.setClientId(DorisAssit.getGConfValue("clientId"));
        chkConfig.setServerHost(DorisAssit.getGConfValue("host"));
        chkConfig.setSourceHost(DorisAssit.getGlobalValue("host"));
        return chkConfig;
    }

    static {
        Conf.overConf((String)"/common-doris.properties", DorisAssit.class, (boolean)false);
    }
}

