/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.doris.constant;

import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import net.wicp.tams.common.doris.bean.CheckPointConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class CheckpointService {
    private static final Logger log = LoggerFactory.getLogger(CheckpointService.class);
    private final String fieldDelimiter = ",";
    private static String DESC_DB_TB = "DESC %s.%s";
    private static String COLUMN_TYPE_FORMAT = "%s(%s)";
    private static CheckPointConfig checkPointConfig;
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;

    public CheckpointService(CheckPointConfig checkPointConfig) {
        CheckpointService.checkPointConfig = checkPointConfig;
        if (!StringUtils.isEmpty((Object)checkPointConfig.getHost())) {
            this.dataSource = this.getDataSource(checkPointConfig.getDbName());
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        }
    }

    public DataSource getDataSource(String db) {
        StringBuilder url = new StringBuilder("");
        url.append("jdbc:mysql://");
        url.append(checkPointConfig.getHost() + ":" + checkPointConfig.getPort());
        url.append("/");
        url.append(db);
        return DataSourceBuilder.create().url(url.toString()).username(checkPointConfig.getUser()).password(checkPointConfig.getPassword()).driverClassName("com.mysql.jdbc.Driver").type(HikariDataSource.class).build();
    }

    public void deleteChk(long timeStr) {
        if (checkPointConfig.getHost() != null) {
            StringBuilder sql = new StringBuilder("");
            sql.append(" delete from position where ");
            sql.append(" clintId = ").append("'").append(checkPointConfig.getClientId()).append("'");
            sql.append(" and serverIp = ").append("'").append(checkPointConfig.getServerHost()).append("'");
            sql.append(" and time >= ").append(timeStr).append(";");
            this.jdbcTemplate.execute(sql.toString());
        }
    }
}

