/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.doris.plugin;

import cn.hutool.json.JSONUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.constant.Middleware;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.doris.bean.DorisConfig;
import net.wicp.tams.common.doris.constant.DorisAssit;
import net.wicp.tams.common.doris.constant.DorisStreamLoadBe;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class DumperDoris
implements IBusiSender<DumpEvent> {
    private static final Logger log = LoggerFactory.getLogger(DumperDoris.class);
    private final DorisConfig dorisConfig = DorisAssit.initDefaultConfig();
    private final DorisStreamLoadBe dorisStreamLoad = new DorisStreamLoadBe(this.dorisConfig);

    public void init(Dump dump) {
        dump.getRule().checkRule(Middleware.doris);
        this.dorisConfig.setDb(dump.getRule().getRuleItem(RuleItem.db));
        this.dorisConfig.setTb(dump.getRule().getRuleItem(RuleItem.tb));
    }

    public void doSend(DumpEvent dumpEvent, Map<AddColName, Serializable> addValues, String newDb, String newTb) {
        log.info("dataDump:db={},tb={}", (Object)newDb, (Object)newTb);
        StopWatch sw = new StopWatch();
        sw.start("doris-dump-start");
        try {
            List dataList = dumpEvent.getDatas();
            this.dorisStreamLoad.flushAndRetry(newDb, newTb, JSONUtil.toJsonStr((Object)dataList));
        }
        catch (Exception e) {
            log.error("dump stream load error", (Throwable)e);
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, (Throwable)e);
        }
        sw.stop();
        log.info(sw.getLastTaskName() + ":" + sw.getTotalTimeMillis());
    }
}

