/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.doris.constant;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class DorisTest {
    private static final String HOST = "192.168.32.232";
    private static final int PORT = 8030;
    private static final String DATABASE = "test";
    private static final String TABLE = "ods_dental_accountstatement";
    private static final String USER = "root";
    private static final String PASSWD = "ZDNhMjdmNzIxYTI2";
    private static final String LOAD_FILE_NAME = "c:/es/1.csv";
    private static final String loadUrl = String.format("http://%s:%s/api/%s/%s/_stream_load", "192.168.32.232", 8030, "test", "ods_dental_accountstatement");
    private static final HttpClientBuilder httpClientBuilder = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

        protected boolean isRedirectable(String method) {
            return true;
        }
    });

    public void load(File file) throws Exception {
        try (CloseableHttpClient client = httpClientBuilder.build();){
            HttpPut put = new HttpPut(loadUrl);
            put.removeHeaders("Content-Length");
            put.removeHeaders("Transfer-Encoding");
            put.setHeader("Expect", "100-continue");
            put.setHeader("Authorization", this.basicAuthHeader(USER, PASSWD));
            put.setHeader("label", UUID.randomUUID().toString());
            put.setHeader("column_separator", ",");
            FileEntity entity = new FileEntity(file);
            put.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)put);){
                int statusCode;
                String loadResult = "";
                if (response.getEntity() != null) {
                    loadResult = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                if ((statusCode = response.getStatusLine().getStatusCode()) != 200) {
                    throw new IOException(String.format("Stream load failed. status: %s load result: %s", statusCode, loadResult));
                }
                System.out.println("Get load result: " + loadResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadJsonAppend(String jsonData) throws Exception {
        try (CloseableHttpClient client = httpClientBuilder.build();){
            HttpPut put = new HttpPut(loadUrl);
            put.removeHeaders("Content-Length");
            put.removeHeaders("Transfer-Encoding");
            put.addHeader("Expect", "100-continue");
            put.setHeader("Authorization", this.basicAuthHeader(USER, PASSWD));
            put.setHeader("label", UUID.randomUUID().toString());
            put.setHeader("column_separator", ",");
            put.setHeader("format", "json");
            put.setHeader("strip_outer_array", "true");
            StringEntity entity = new StringEntity(jsonData, "UTF-8");
            put.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)put);){
                int statusCode;
                String loadResult = "";
                if (response.getEntity() != null) {
                    loadResult = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                if ((statusCode = response.getStatusLine().getStatusCode()) != 200) {
                    throw new IOException(String.format("Stream load failed. status: %s load result: %s", statusCode, loadResult));
                }
                System.out.println("Get load result: " + loadResult);
            }
            finally {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadJsonDelete(String jsonData) throws Exception {
        try (CloseableHttpClient client = httpClientBuilder.build();){
            HttpPut put = new HttpPut(loadUrl);
            put.setHeader("Content-Encoding", "UTF-8");
            put.setHeader("Transfer-Encoding", "UTF-8");
            put.setHeader("Accept-Encoding", "UTF-8");
            put.setHeader("Expect", "100-continue");
            put.setHeader("Content-Type", "text/plain;charset=UTF-8");
            put.setHeader("Authorization", this.basicAuthHeader(USER, PASSWD));
            put.setHeader("label", UUID.randomUUID().toString());
            put.setHeader("label", UUID.randomUUID().toString());
            put.setHeader("column_separator", ",");
            put.setHeader("format", "json");
            put.setHeader("strip_outer_array", "true");
            put.setHeader("merge_type", "DELETE");
            StringEntity entity = new StringEntity(jsonData);
            put.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)put);){
                int statusCode;
                String loadResult = "";
                if (response.getEntity() != null) {
                    loadResult = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                if ((statusCode = response.getStatusLine().getStatusCode()) != 200) {
                    throw new IOException(String.format("Stream load failed. status: %s load result: %s", statusCode, loadResult));
                }
                System.out.println("Get load result: " + loadResult);
            }
            finally {
                client.close();
            }
        }
    }

    private String basicAuthHeader(String username, String password) {
        String tobeEncode = username + ":" + password;
        byte[] encoded = Base64.encodeBase64((byte[])tobeEncode.getBytes(StandardCharsets.UTF_8));
        return "Basic " + new String(encoded);
    }

    public static void main(String[] args) throws Exception {
        DorisTest loader = new DorisTest();
        String jsonData = "[{\"tenantid\":10000,\"id\":\"27\",\"accountorname\":\"\u7b49\u7b49\u54c8\u54c8\u770b\"},{\"id\":26,\"tenantid\":\"10000\",\"accountorname\":\"\u7b49\u7b49\u7684\"}]";
        loader.loadJsonAppend(jsonData);
    }
}

