/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.doris.constant;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.doris.bean.CheckPointConfig;
import net.wicp.tams.common.doris.bean.DorisConfig;
import net.wicp.tams.common.doris.constant.AlterMessage;
import net.wicp.tams.common.doris.constant.DorisSink;
import net.wicp.tams.common.doris.constant.SqlUtil;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DorisJdbcLoad {
    private static final Logger log = LoggerFactory.getLogger(DorisJdbcLoad.class);
    private final String fieldDelimiter = ",";
    private static final String DESC_DB_TB = "DESC %s.%s";
    private static final String COLUMN_TYPE_FORMAT = "%s(%s)";
    private static DorisConfig dorisConfig;
    private static final String checkBatchDeleteColumn = "__DORIS_DELETE_SIGN__";
    private static final Map<String, Boolean> dbtbCheckMap;
    private final DataSource dorisDataSource;
    private final JdbcTemplate dorisJdbcTemplate;
    private DorisSink dorisSink;
    private final CheckPointConfig checkPointConfig;

    public DorisJdbcLoad(DorisConfig dorisConfig, CheckPointConfig checkPointConfig) {
        DorisJdbcLoad.dorisConfig = dorisConfig;
        this.dorisDataSource = this.getDorisDataSource(dorisConfig.getDb());
        this.dorisJdbcTemplate = new JdbcTemplate(this.dorisDataSource);
        this.checkPointConfig = checkPointConfig;
    }

    public DataSource getDorisDataSource(String db) {
        StringBuilder url = new StringBuilder();
        url.append("jdbc:mysql://");
        url.append(dorisConfig.getHost() + ":" + dorisConfig.getJdbcPort());
        url.append("/");
        url.append(db);
        return DataSourceBuilder.create().url(url.toString()).username(dorisConfig.getUsername()).password(dorisConfig.getPassword()).driverClassName("com.mysql.jdbc.Driver").type(HikariDataSource.class).build();
    }

    public Boolean alterTable(Rule rule, ListenerConf.ColHis colHis, String[] addColNames, String sql, String db, String tb) {
        Boolean alterResult = true;
        this.executeAddColumn(rule, colHis, addColNames, sql, db, tb);
        this.executeModifyColumn(rule, colHis, addColNames, sql, db, tb);
        return alterResult;
    }

    private boolean executeAddColumn(Rule rule, ListenerConf.ColHis colHis, String[] addColNames, String sql, String db, String tb) {
        Boolean alterResult = false;
        String alterSql = null;
        try {
            alterSql = this.generateAddColumnSql(rule, colHis, addColNames, sql, db, tb);
            if (StringUtils.isEmpty((Object)alterSql)) {
                return true;
            }
            this.dorisJdbcTemplate.execute(alterSql);
        }
        catch (Exception e) {
            String msg = e.getCause().getMessage().toLowerCase();
            if (msg.contains("add column which already exists")) {
                log.info("\u6dfb\u52a0\u5b57\u6bb5\u6210\u529f: " + alterSql);
            } else if (msg.contains("can not change default value")) {
                System.out.println("\u4e0d\u53ef\u4fee\u6539\u9ed8\u8ba4\u503c: " + alterSql);
            } else {
                log.error("\u4fee\u6539\u8868\u7ed3\u6784\u5931\u8d25\uff01", (Throwable)e);
                alterResult = false;
                AlterMessage.alterMsgDDL(this.checkPointConfig.getSourceHost(), alterSql, msg);
            }
            return alterResult;
        }
        String sqlCheck = String.format(DESC_DB_TB, db, tb);
        while (true) {
            try {
                List list = this.dorisJdbcTemplate.queryForList(sqlCheck);
                ArrayList tableColumns = Lists.newArrayList();
                list.stream().forEach(stringObjectMap -> tableColumns.add(stringObjectMap.get("Field").toString()));
                log.info("\u5c1d\u8bd5\u83b7\u53d6\u5b57\u6bb5\uff01");
                if (tableColumns.containsAll(Lists.newArrayList((Object[])addColNames))) {
                    alterResult = true;
                    log.info("\u65b0\u589e\u5b57\u6bb5\u6210\u529f\uff01");
                }
                if (!alterResult.booleanValue()) {
                    throw new ProjectException((IExcept)ExceptAll.Project_default, "\u672a\u83b7\u53d6\u5230\u4fee\u6539\u8868\u7ed3\u6784\u5b57\u6bb5\u7ed3\u679c\uff01");
                }
            }
            catch (Throwable e) {
                boolean reDoWait;
                if (!(reDoWait = TimeAssist.reDoWait((String)"doris-alterTable", (int)dorisConfig.getSqlRetryTimes()))) continue;
                log.error("\u91cd\u8bd5{}\u6b21,\u672a\u83b7\u53d6\u5230\u4fee\u6539\u8868\u7ed3\u6784\u5b57\u6bb5\u7ed3\u679c\uff01", (Object)dorisConfig.getSqlRetryTimes());
                AlterMessage.alterMsgDDL(this.checkPointConfig.getSourceHost(), alterSql, "\u91cd\u8bd5\u591a\u6b21,\u672a\u83b7\u53d6\u5230\u4fee\u6539\u8868\u7ed3\u6784\u5b57\u6bb5\u7ed3\u679c\uff01");
            }
            break;
        }
        return alterResult;
    }

    private Boolean executeModifyColumn(Rule rule, ListenerConf.ColHis colHis, String[] addColNames, String sql, String db, String tb) {
        Boolean alterResult = false;
        String alterSql = null;
        try {
            alterSql = this.generateModifyColumnSql(rule, colHis, addColNames, sql, db, tb);
            if (StringUtils.isEmpty((Object)alterSql)) {
                return true;
            }
            this.dorisJdbcTemplate.execute(alterSql);
        }
        catch (Exception e) {
            String msg = e.getCause().getMessage().toLowerCase();
            if (msg.contains("add column which already exists")) {
                log.info("\u6dfb\u52a0\u5b57\u6bb5\u6210\u529f: " + alterSql);
            } else if (msg.contains("can not change default value")) {
                System.out.println("\u4e0d\u53ef\u4fee\u6539\u9ed8\u8ba4\u503c: " + alterSql);
            } else {
                log.error("\u4fee\u6539\u8868\u7ed3\u6784\u5931\u8d25\uff01", (Throwable)e);
                alterResult = false;
                AlterMessage.alterMsgDDL(this.checkPointConfig.getSourceHost(), alterSql, msg);
            }
            return alterResult;
        }
        String sqlCheck = String.format(DESC_DB_TB, db, tb);
        while (true) {
            try {
                List list = this.dorisJdbcTemplate.queryForList(sqlCheck);
                ArrayList tableColumns = Lists.newArrayList();
                list.stream().forEach(stringObjectMap -> tableColumns.add(stringObjectMap.get("Field").toString()));
                log.info("\u5c1d\u8bd5\u83b7\u53d6\u5b57\u6bb5\uff01");
                if (tableColumns.containsAll(Lists.newArrayList((Object[])addColNames))) {
                    alterResult = true;
                    log.info("\u65b0\u589e\u5b57\u6bb5\u6210\u529f\uff01");
                }
                if (!alterResult.booleanValue()) {
                    throw new ProjectException((IExcept)ExceptAll.Project_default, "\u672a\u83b7\u53d6\u5230\u4fee\u6539\u8868\u7ed3\u6784\u5b57\u6bb5\u7ed3\u679c\uff01");
                }
            }
            catch (Throwable e) {
                boolean reDoWait;
                if (!(reDoWait = TimeAssist.reDoWait((String)"doris-alterTable", (int)dorisConfig.getSqlRetryTimes()))) continue;
                log.error("\u91cd\u8bd5{}\u6b21,\u672a\u83b7\u53d6\u5230\u4fee\u6539\u8868\u7ed3\u6784\u5b57\u6bb5\u7ed3\u679c\uff01", (Object)dorisConfig.getSqlRetryTimes());
                AlterMessage.alterMsgDDL(this.checkPointConfig.getSourceHost(), alterSql, "\u91cd\u8bd5\u591a\u6b21,\u672a\u83b7\u53d6\u5230\u4fee\u6539\u8868\u7ed3\u6784\u5b57\u6bb5\u7ed3\u679c\uff01");
            }
            break;
        }
        return alterResult;
    }

    private String generateAddColumnSql(Rule rule, ListenerConf.ColHis colHis, String[] addColNames, String sql, String db, String tb) {
        Map<String, SQLColumnDefinition> columnDefinitionMap = SqlUtil.getColumnDefinitionMap(sql);
        if (CollectionUtils.isEmpty(columnDefinitionMap)) {
            return null;
        }
        StringBuilder alterSql = new StringBuilder();
        alterSql.append("alter table ").append(db).append(".").append(tb).append(" ");
        for (String column : addColNames) {
            column = column.replaceAll("`", "");
            alterSql.append("add column ").append(column).append(" ");
            if (columnDefinitionMap.get(column) != null) {
                alterSql.append(this.convertColumnType(columnDefinitionMap.get(column)));
            } else {
                alterSql.append(colHis.getColTypes2(colHis.getColsList().indexOf((Object)column)));
            }
            alterSql.append(" REPLACE ");
            if (columnDefinitionMap.get(column) != null && columnDefinitionMap.get(column).getDefaultExpr() != null) {
                alterSql.append(" DEFAULT '").append(columnDefinitionMap.get(column).getDefaultExpr().toString()).append("'");
            }
            if (columnDefinitionMap.get(column) != null && columnDefinitionMap.get(column).getComment() != null) {
                alterSql.append(" COMMENT ").append(columnDefinitionMap.get(column).getComment().toString());
            }
            alterSql.append(" ,");
        }
        alterSql.deleteCharAt(alterSql.length() - 1);
        alterSql.append(";");
        return alterSql.toString();
    }

    private String generateModifyColumnSql(Rule rule, ListenerConf.ColHis colHis, String[] addColNames, String sql, String db, String tb) {
        Map<String, SQLColumnDefinition> modifyDefinitionMap = SqlUtil.getModifyColumnDefinitionMap(sql);
        if (CollectionUtils.isEmpty(modifyDefinitionMap)) {
            return null;
        }
        StringBuilder alterSql = new StringBuilder();
        String fullTableName = String.format("%s.%s ", db, tb);
        alterSql.append(" ALTER TABLE ").append(fullTableName);
        if (modifyDefinitionMap != null && modifyDefinitionMap.size() > 0) {
            modifyDefinitionMap.forEach((k, value) -> {
                alterSql.append(" MODIFY COLUMN ").append("`").append((String)k).append("` ").append(this.convertColumnType((SQLColumnDefinition)value)).append(" REPLACE NULL");
                if (modifyDefinitionMap.get(k) != null && ((SQLColumnDefinition)modifyDefinitionMap.get(k)).getDefaultExpr() != null) {
                    String defaultValue = ((SQLColumnDefinition)modifyDefinitionMap.get(k)).getDefaultExpr().toString().replaceAll("'", "");
                    alterSql.append(" DEFAULT '").append(defaultValue).append("' ");
                }
                alterSql.append(",");
            });
        }
        if (alterSql.length() > 0) {
            alterSql.deleteCharAt(alterSql.length() - 1);
        }
        return alterSql.toString();
    }

    private String convertColumnType(SQLColumnDefinition definition) {
        String mysqlType;
        String type = "varchar(255)";
        switch (mysqlType = definition.getDataType().getName().toLowerCase()) {
            case "boolean": 
            case "date": 
            case "float": 
            case "tinyint": 
            case "smallint": 
            case "int": 
            case "bigint": 
            case "double": 
            case "datetime": 
            case "timestamp": 
            case "decimal": {
                type = "varchar(50)";
                break;
            }
            case "varchar": 
            case "char": {
                int length = definition.getDataType().getArguments() == null ? 100 : Integer.parseInt(((SQLExpr)definition.getDataType().getArguments().get(0)).toString());
                type = String.format(COLUMN_TYPE_FORMAT, definition.getDataType().getName(), length * 4);
                break;
            }
            case "text": 
            case "longtext": 
            case "mediumtext": 
            case "tinytext": 
            case "json": 
            case "blob": {
                type = "string";
                break;
            }
            default: {
                type = "string";
            }
        }
        return type;
    }

    public Boolean checkBatchDelete(String db, String tb) {
        Boolean isSupported = false;
        if (dbtbCheckMap.get(String.format(DESC_DB_TB, db, tb)) != null && dbtbCheckMap.get(db + tb).booleanValue()) {
            isSupported = true;
        } else {
            isSupported = this.checkBatchDeleteJdbc(db, tb);
            dbtbCheckMap.put(String.format(DESC_DB_TB, db, tb), isSupported);
        }
        return isSupported;
    }

    public Boolean checkBatchDeleteJdbc(String db, String tb) {
        Boolean isSupported = false;
        StringBuilder alterTableEnableBatchDelete = new StringBuilder();
        alterTableEnableBatchDelete.append("ALTER TABLE ");
        alterTableEnableBatchDelete.append(tb).append(" ");
        alterTableEnableBatchDelete.append("ENABLE FEATURE 'BATCH_DELETE';");
        String sqlCheckBefore = "SET show_hidden_columns=true;";
        String sqlCheck = String.format(DESC_DB_TB, db, tb);
        try {
            this.dorisJdbcTemplate.execute(alterTableEnableBatchDelete.toString());
        }
        catch (Exception e) {
            log.info("\u6dfb\u52a0\u6279\u91cf\u5220\u9664\u6743\u9650\u5931\u8d25,\u53ef\u80fd\u5df2\u6709\u6743\u9650!", (Throwable)e);
        }
        while (true) {
            try {
                this.dorisJdbcTemplate.execute(sqlCheckBefore);
                List list = this.dorisJdbcTemplate.queryForList(sqlCheck);
                Collections.reverse(list);
                for (Map map : list) {
                    if (!checkBatchDeleteColumn.equals(map.get("Field"))) continue;
                    isSupported = true;
                    break;
                }
                if (!isSupported.booleanValue()) {
                    throw new ProjectException((IExcept)ExceptAll.Project_default, "\u672a\u83b7\u53d6\u5230\u6279\u91cf\u5220\u9664\u6807\u8bb0\uff01");
                }
            }
            catch (Throwable e) {
                boolean reDoWait;
                if (!(reDoWait = TimeAssist.reDoWait((String)"doris-batchDelete", (int)dorisConfig.getSqlRetryTimes()))) continue;
                log.error("\u91cd\u8bd53\u6b21,\u672a\u83b7\u53d6\u5230\u6279\u91cf\u5220\u9664\u6807\u8bb0\uff01");
            }
            break;
        }
        return isSupported;
    }

    static {
        dbtbCheckMap = Maps.newHashMap();
    }
}

