package net.wicp.tams.common.doris.plugin;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import org.springframework.util.StopWatch;

import cn.hutool.json.JSONUtil;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.constant.Middleware;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.doris.bean.DorisConfig;
import net.wicp.tams.common.doris.constant.DorisAssit;
import net.wicp.tams.common.doris.constant.DorisStreamLoadBe;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

@Slf4j
public class DumperDoris implements IBusiSender<DumpEvent> {
	private final DorisConfig dorisConfig;
	private final DorisStreamLoadBe dorisStreamLoad;

	public DumperDoris() {
		this.dorisConfig = DorisAssit.initDefaultConfig();
		this.dorisStreamLoad = new DorisStreamLoadBe(dorisConfig);
	}

	@Override
	public void init(Dump dump) {
//		String[] dbtb = dump.getBusiPluginConfig().getString(RuleItem.db.name()).split("\\.");
		dump.getRule().checkRule(Middleware.doris);
		dorisConfig.setDb(dump.getRule().getRuleItem(RuleItem.db));
		dorisConfig.setTb(dump.getRule().getRuleItem(RuleItem.tb));
	}

	@Override
	public void doSend(DumpEvent dumpEvent, Map<AddColName, Serializable> addValues, String newDb, String newTb) {
		log.info("dataDump:db={},tb={}", newDb, newTb);
		StopWatch sw = new StopWatch();
		sw.start("doris-dump-start");
		try {
			List<Map<String, String>> dataList = dumpEvent.getDatas();
//			dorisStreamLoad.loadJsonArrayAppend(JSONUtil.toJsonStr(dataList),newDb,newTb);
			dorisStreamLoad.flushAndRetry(newDb, newTb, JSONUtil.toJsonStr(dataList));
		} catch (Exception e) {
			log.error("dump stream load error", e);
			throw new ProjectExceptionRuntime(ExceptAll.Project_default, e);
		}
		sw.stop();
		log.info(sw.getLastTaskName() + ":" + sw.getTotalTimeMillis());
	}

}
