package net.wicp.tams.common.doris.constant;


import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableChangeColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableModifyColumn;
import com.alibaba.druid.util.JdbcConstants;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;


/**
 * sql解析工具
 */
@Slf4j
public class SqlUtil {
    public static Map<String, SQLColumnDefinition> getColumnDefinitionMap(String sql){
        Map<String, SQLColumnDefinition> map = Maps.newHashMap();
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, JdbcConstants.MYSQL);
        try{
            SQLAlterTableStatement sqlStatement = (SQLAlterTableStatement) stmtList.get(0);
            List<SQLAlterTableItem> items = sqlStatement.getItems();
            for(SQLAlterTableItem item : items){
                if(item instanceof SQLAlterTableAddColumn){
                    SQLAlterTableAddColumn temp = (SQLAlterTableAddColumn) item;
                    for(SQLColumnDefinition definition : temp.getColumns()){
                        map.put(definition.getNameAsString().replaceAll("`", ""),definition);
                    }
                }
                if(item instanceof MySqlAlterTableChangeColumn) {
                    MySqlAlterTableChangeColumn temp = (MySqlAlterTableChangeColumn) item;
                    SQLColumnDefinition definition = temp.getNewColumnDefinition();
                    map.put(definition.getNameAsString().replaceAll("`", ""),definition);
                }

            }
        } catch (Exception e){
            log.info("获取新增字段失败："+sql,e);
        }

        return map;
    }

    public static Map<String, SQLColumnDefinition> getModifyColumnDefinitionMap(String sql){
        Map<String, SQLColumnDefinition> map = Maps.newHashMap();
        List<SQLStatement> stmtList = SQLUtils.parseStatements(sql, JdbcConstants.MYSQL);
        try {
            SQLAlterTableStatement sqlStatement = (SQLAlterTableStatement) stmtList.get(0);
            List<SQLAlterTableItem> items = sqlStatement.getItems();
            for(SQLAlterTableItem item : items){
                if(item instanceof MySqlAlterTableModifyColumn) {
                    MySqlAlterTableModifyColumn temp = (MySqlAlterTableModifyColumn) item;
                    SQLColumnDefinition definition = temp.getNewColumnDefinition();
                    map.put(definition.getNameAsString().replaceAll("`", ""),definition);
                }

            }
        } catch (Exception e){
            log.info("获取修改字段失败："+sql,e);
        }

        return map;
    }

}
