package net.wicp.tams.common.doris.constant;


import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.doris.bean.WechatMessageType;
import net.wicp.tams.common.doris.bean.WechatTextRe;
import org.apache.commons.compress.utils.Lists;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;

@Slf4j
public class AlterMessage {

//    public static void main(String[] args) {
//        alterMsgDDL("测试","请忽略");
//    }

    public static void sendGet(String urlParam) {
        HttpGet httpGet = new HttpGet(urlParam);
        CloseableHttpResponse response = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            response = httpClient.execute(httpGet);
            int status = response.getStatusLine().getStatusCode();
            log.error("GET请求发出成功，请求的地址为{}，返回状态为{}", urlParam, status);
        } catch (IOException e) {
            log.error("GET请求发出失败，请求的地址为{}，错误信息为{}", urlParam, e.getMessage(), e);
        } finally {
            try {
                if (response != null) {
                    response.close();
                }
            } catch (IOException e) {
                log.error("GET请求response关闭异常，错误信息为{}", e.getMessage(), e);
            }
        }
    }

    public static void alterMsgDDL(String jobName,String sql,String errorMsg){
        StringBuilder content = new StringBuilder("");
        content.append(jobName);
        content.append(" ddl异常，请关注！").append(System.lineSeparator())
                .append("sql:").append(sql).append(System.lineSeparator())
                .append("errorMsg:").append(errorMsg);
        WechatTextRe req = new WechatTextRe();
        WechatTextRe.Text text = new WechatTextRe.Text();
        text.setContent(content.toString());
        List mobilelist = Lists.newArrayList();
        mobilelist.add("15537137251");
        text.setMentioned_mobile_list(new HashSet<>(mobilelist));
        req.setMsgtype(WechatMessageType.text.getDesc());
        req.setText(text);
        String url = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=6ba21f78-bf6d-45ae-9592-b8fff2a6415c";
        sendPost(url,req);
    }

    public static void alterMsgDataError(String jobName,String errorMsg){
        StringBuilder content = new StringBuilder("");
        content.append(jobName).append(" 同步数据异常，请关注！").append(System.lineSeparator())
                .append("errorMsg:").append(errorMsg);
        WechatTextRe req = new WechatTextRe();
        WechatTextRe.Text text = new WechatTextRe.Text();
        text.setContent(content.toString());
        List mobilelist = Lists.newArrayList();
        mobilelist.add("15537137251");
        text.setMentioned_mobile_list(new HashSet<>(mobilelist));
        req.setMsgtype(WechatMessageType.text.getDesc());
        req.setText(text);
        String url = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=6ba21f78-bf6d-45ae-9592-b8fff2a6415c";
        sendPost(url,req);
    }

    public static void sendPost(String url, WechatTextRe req ) {
        CloseableHttpResponse response = null;

        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            String encoding = "utf-8";
            //创建post请求对象
            HttpPost httpPost = new HttpPost(url);
            //装填请求参数
            StringEntity postingString = new StringEntity(JSON.toJSONString(req),encoding);// json传递
            httpPost.setEntity(postingString);
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            response = httpClient.execute(httpPost);

        } catch (IOException e) {
            log.error("POST请求发出失败，请求的地址为{}，参数为{}，错误信息为{}", url, JSON.toJSON(req), e.getMessage(), e);
        } finally {
            try {
                if (response != null) {
                    response.close();
                }
            } catch (IOException e) {
                log.error("POST请求response关闭异常，错误信息为{}", e.getMessage(), e);
            }
        }
    }
}
