/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.doris.plugin;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBinlogListener;
import net.wicp.tams.common.doris.bean.DorisConfig;
import net.wicp.tams.common.doris.constant.DorisAssit;
import net.wicp.tams.common.doris.constant.DorisJdbcLoad;
import net.wicp.tams.common.doris.constant.DorisStreamLoad;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerDoris
extends AbsBinlogListener {
    private static final Logger log = LoggerFactory.getLogger(ListenerDoris.class);
    private final DorisConfig dorisConfig = DorisAssit.initDefaultConfig();
    private final DorisStreamLoad dorisStreamLoad;
    private final DorisJdbcLoad dorisJdbcLoad = new DorisJdbcLoad(this.dorisConfig);

    public ListenerDoris() {
        this.dorisStreamLoad = new DorisStreamLoad(this.dorisConfig);
    }

    public void doInit(Rule rule, int index) {
    }

    public void doBusiTrue(Rule rule, ListenerConf.DuckulaEvent duckulaEvent, boolean isSplit) {
        ListenerConf.OptType optType = duckulaEvent.getOptType();
        ListenerConf.DuckulaEvent.Builder builder = duckulaEvent.toBuilder();
        ArrayList dataList = Lists.newArrayList();
        for (int i = 0; i < duckulaEvent.getItemsCount(); ++i) {
            dataList.add(DuckulaAssit.getValueMap((ListenerConf.DuckulaEvent)duckulaEvent, (int)i));
        }
        String[] dbtb = ((String)rule.getItems().get(RuleItem.dbtb)).split("\\.");
        String db = dbtb[0];
        String tb = dbtb[1];
        if (CollectionUtil.isNotEmpty((Collection)dataList)) {
            if (optType == ListenerConf.OptType.delete) {
                try {
                    if (!this.dorisJdbcLoad.checkBatchDelete(db, tb).booleanValue()) {
                        throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u4e0d\u652f\u6301\u6279\u91cf\u5220\u9664\u64cd\u4f5c\uff01");
                    }
                    this.dorisStreamLoad.loadJsonArrayDelete(JSONUtil.toJsonStr((Object)dataList), db, tb);
                }
                catch (Exception e) {
                    log.error("stream load delete error", (Throwable)e);
                    throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, (Throwable)e);
                }
            }
            try {
                this.dorisStreamLoad.loadJsonArrayAppend(JSONUtil.toJsonStr((Object)dataList), db, tb);
            }
            catch (Exception e) {
                log.error("stream load append error", (Throwable)e);
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, (Throwable)e);
            }
        }
    }

    public Result doAlterTableCallBack(Rule rule, ListenerConf.ColHis colHis, String sql, String[] addColNames, String updateColName, String[] deleteColNames) {
        if (addColNames == null || addColNames.length < 1) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u65b0\u589e\u5b57\u6bb5\u4e3a\u7a7a");
        }
        Boolean result = this.dorisJdbcLoad.alterTable(rule, colHis, addColNames);
        if (!result.booleanValue()) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default);
        }
        log.info("doris\u4fee\u6539\u8868\u7ed3\u6784\u6210\u529f\uff01");
        return Result.getSuc();
    }
}

