/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.doris.plugin;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.doris.bean.DorisConfig;
import net.wicp.tams.common.doris.constant.DorisAssit;
import net.wicp.tams.common.doris.constant.DorisStreamLoad;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class DumperDoris
implements IBusiSender<DumpEvent> {
    private static final Logger log = LoggerFactory.getLogger(DumperDoris.class);
    private final DorisConfig dorisConfig = DorisAssit.initDefaultConfig();
    private final DorisStreamLoad dorisStreamLoad = new DorisStreamLoad(this.dorisConfig);

    public void init(Dump dump) {
        String[] dbtb = dump.getBusiPluginConfig().getString(RuleItem.dbtb.name()).split("\\.");
        this.dorisConfig.setDb(dbtb[0]);
        this.dorisConfig.setTb(dbtb[1]);
    }

    public void initParams(JSONObject params) {
    }

    public void doSend(DumpEvent dumpEvent) {
        log.info("\u6570\u636e\u6765\u4e86" + dumpEvent.getDatas().size());
        StopWatch sw = new StopWatch();
        sw.start("doris-dump-start");
        try {
            List dataList = dumpEvent.getDatas();
            this.dorisStreamLoad.loadJsonArrayAppend(JSONUtil.toJsonStr((Object)dataList));
        }
        catch (Exception e) {
            log.error("dump stream load error", (Throwable)e);
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, (Throwable)e);
        }
        sw.stop();
        log.info(sw.getLastTaskName() + ":" + sw.getTotalTimeMillis());
    }
}

