/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.doris.constant;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ProtocolStringList;
import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.doris.bean.DorisConfig;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.jdbc.core.JdbcTemplate;

public class DorisJdbcLoad {
    private static final Logger log = LoggerFactory.getLogger(DorisJdbcLoad.class);
    private static String DESC_DB_TB = "DESC %s.%s";
    private static DorisConfig dorisConfig;
    private static final String checkBatchDeleteColumn = "__DORIS_DELETE_SIGN__";
    private static final Map<String, Boolean> dbtbCheckMap;
    private DataSource dorisDataSource;
    private JdbcTemplate dorisJdbcTemplate;

    public DorisJdbcLoad(DorisConfig dorisConfig) {
        DorisJdbcLoad.dorisConfig = dorisConfig;
        this.dorisDataSource = this.getDorisDataSource(dorisConfig.getDb());
        this.dorisJdbcTemplate = new JdbcTemplate(this.dorisDataSource);
    }

    public DataSource getDorisDataSource(String db) {
        StringBuilder url = new StringBuilder("");
        url.append("jdbc:mysql://");
        url.append(dorisConfig.getHost() + ":" + dorisConfig.getJdbcPort());
        url.append("/");
        url.append(db);
        return DataSourceBuilder.create().url(url.toString()).username(dorisConfig.getUsername()).password(dorisConfig.getPassword()).driverClassName("com.mysql.jdbc.Driver").type(HikariDataSource.class).build();
    }

    public Boolean checkBatchDelete(String db, String tb) {
        Boolean isSupported = false;
        if (dbtbCheckMap.get(String.format(DESC_DB_TB, db, tb)) != null && dbtbCheckMap.get(db + tb).booleanValue()) {
            isSupported = true;
        } else {
            isSupported = this.checkBatchDeleteJdbc(db, tb);
            dbtbCheckMap.put(String.format(DESC_DB_TB, db, tb), isSupported);
        }
        return isSupported;
    }

    public Boolean checkBatchDeleteJdbc(String db, String tb) {
        Boolean isSupported = false;
        StringBuilder alterTableEnableBatchDelete = new StringBuilder();
        alterTableEnableBatchDelete.append("ALTER TABLE ");
        alterTableEnableBatchDelete.append(tb).append(" ");
        alterTableEnableBatchDelete.append("ENABLE FEATURE 'BATCH_DELETE';");
        String sqlCheckBefore = "SET show_hidden_columns=true;";
        String sqlCheck = String.format(DESC_DB_TB, db, tb);
        try {
            this.dorisJdbcTemplate.execute(alterTableEnableBatchDelete.toString());
        }
        catch (Exception e) {
            log.info("\u6dfb\u52a0\u6279\u91cf\u5220\u9664\u6743\u9650\u5931\u8d25,\u53ef\u80fd\u5df2\u6709\u6743\u9650!", (Throwable)e);
        }
        while (true) {
            try {
                this.dorisJdbcTemplate.execute(sqlCheckBefore);
                List list = this.dorisJdbcTemplate.queryForList(sqlCheck);
                Collections.reverse(list);
                for (Map map : list) {
                    if (!checkBatchDeleteColumn.equals(map.get("Field"))) continue;
                    isSupported = true;
                    break;
                }
                if (!isSupported.booleanValue()) {
                    throw new ProjectException((IExcept)ExceptAll.Project_default, "\u672a\u83b7\u53d6\u5230\u6279\u91cf\u5220\u9664\u6807\u8bb0\uff01");
                }
            }
            catch (Throwable e) {
                boolean reDoWait;
                if (!(reDoWait = TimeAssist.reDoWait((String)"doris-batchDelete", (int)dorisConfig.getSqlRetryTimes()))) continue;
                log.error("\u91cd\u8bd53\u6b21,\u672a\u83b7\u53d6\u5230\u6279\u91cf\u5220\u9664\u6807\u8bb0\uff01");
            }
            break;
        }
        return isSupported;
    }

    public Boolean alterTable(Rule rule, ListenerConf.ColHis colHis, String[] addColNames) {
        Boolean alterResult = false;
        String[] dbtb = ((String)rule.getItems().get(RuleItem.dbtb)).split("\\.");
        String db = dbtb[0];
        String tb = dbtb[1];
        String sql = this.generateAddColumnSql(rule, colHis, addColNames);
        try {
            this.dorisJdbcTemplate.execute(sql);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u8868\u7ed3\u6784\u5931\u8d25\uff01", (Throwable)e);
            alterResult = false;
            return alterResult;
        }
        String sqlCheck = String.format(DESC_DB_TB, db, tb);
        while (true) {
            try {
                List list = this.dorisJdbcTemplate.queryForList(sqlCheck);
                ArrayList tableColumns = Lists.newArrayList();
                list.stream().forEach(stringObjectMap -> tableColumns.add(stringObjectMap.get("Field").toString()));
                ProtocolStringList cols = colHis.getColsList();
                if (tableColumns.containsAll((Collection<?>)cols)) {
                    alterResult = true;
                }
                if (!alterResult.booleanValue()) {
                    throw new ProjectException((IExcept)ExceptAll.Project_default, "\u672a\u83b7\u53d6\u5230\u4fee\u6539\u8868\u7ed3\u6784\u5b57\u6bb5\u7ed3\u679c\uff01");
                }
            }
            catch (Throwable e) {
                boolean reDoWait;
                if (!(reDoWait = TimeAssist.reDoWait((String)"doris-alterTable", (int)dorisConfig.getSqlRetryTimes()))) continue;
                log.error("\u91cd\u8bd53\u6b21,\u672a\u83b7\u53d6\u5230\u4fee\u6539\u8868\u7ed3\u6784\u5b57\u6bb5\u7ed3\u679c\uff01");
            }
            break;
        }
        return alterResult;
    }

    private String generateAddColumnSql(Rule rule, ListenerConf.ColHis colHis, String[] addColNames) {
        String[] dbtb = ((String)rule.getItems().get(RuleItem.dbtb)).split("\\.");
        String db = dbtb[0];
        String tb = dbtb[1];
        StringBuilder sql = new StringBuilder("");
        sql.append("alter table ").append(db).append(".").append(tb).append(" ");
        for (String column : addColNames) {
            column = column.replaceAll("`", "");
            sql.append("add column ").append(column).append(" ");
            sql.append(colHis.getColTypes2(colHis.getColsList().indexOf((Object)column))).append(" null ,");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(";");
        return sql.toString();
    }

    static {
        dbtbCheckMap = Maps.newHashMap();
    }
}

