package net.wicp.tams.common.doris.plugin;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBinlogListener;
import net.wicp.tams.common.doris.bean.DorisConfig;
import net.wicp.tams.common.doris.constant.DorisAssit;
import net.wicp.tams.common.doris.constant.DorisJdbcLoad;
import net.wicp.tams.common.doris.constant.DorisStreamLoad;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;

@Slf4j
public class ListenerDoris extends AbsBinlogListener {
	private final DorisConfig dorisConfig;
	private final DorisStreamLoad dorisStreamLoad;
	private final DorisJdbcLoad dorisJdbcLoad;

	public ListenerDoris() {
		this.dorisConfig = DorisAssit.initDefaultConfig();
		this.dorisJdbcLoad = new DorisJdbcLoad(dorisConfig);
		this.dorisStreamLoad = new DorisStreamLoad(dorisConfig);
	}

	@Override
	public void doInit(Rule rule, int index) {
	}

	@Override
	public void doBusiTrue(Rule rule, ListenerConf.DuckulaEvent duckulaEvent, boolean isSplit) {
			ListenerConf.OptType optType = duckulaEvent.getOptType();
			ListenerConf.DuckulaEvent.Builder builder = duckulaEvent.toBuilder();
			List<Map<String,String>> dataList = Lists.newArrayList();
			for (int i = 0; i < duckulaEvent.getItemsCount(); i++) {
				dataList.add(DuckulaAssit.getValueMap(duckulaEvent, i));
			}
			String[] dbtb = rule.getItems().get(RuleItem.dbtb).split("\\.");
			String db = dbtb[0];
			String tb = dbtb[1];
			if(CollectionUtil.isNotEmpty(dataList)){
				if (optType == ListenerConf.OptType.delete) {
					try {
						if(!dorisJdbcLoad.checkBatchDelete(db,tb)){
							throw new ProjectExceptionRuntime(ExceptAll.Project_default,"不支持批量删除操作！");
						}
						dorisStreamLoad.loadJsonArrayDelete(JSONUtil.toJsonStr(dataList),db,tb);
					} catch (Exception e) {
						log.error("stream load delete error",e);
						throw new ProjectExceptionRuntime(ExceptAll.Project_default,e);
					}
				}else {
					try {
						dorisStreamLoad.loadJsonArrayAppend(JSONUtil.toJsonStr(dataList),db,tb);
					} catch (Exception e) {
						log.error("stream load append error",e);
						throw new ProjectExceptionRuntime(ExceptAll.Project_default,e);
					}
				}
			}

	}

	@Override
	public Result doAlterTableCallBack(Rule rule, ListenerConf.ColHis colHis, String sql, String[] addColNames, String updateColName, String[] deleteColNames) {
		if(addColNames == null || addColNames.length < 1){
			throw new ProjectExceptionRuntime(ExceptAll.Project_default,"新增字段为空");
		}
		Boolean result = dorisJdbcLoad.alterTable(rule,colHis,addColNames);
		if(!result){
			throw new ProjectExceptionRuntime(ExceptAll.Project_default);
		}
		log.info("doris修改表结构成功！");
		return Result.getSuc();
	}
}




