package net.wicp.tams.common.doris.plugin;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.doris.bean.DorisConfig;
import net.wicp.tams.common.doris.constant.DorisAssit;
import net.wicp.tams.common.doris.constant.DorisStreamLoad;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.springframework.util.StopWatch;

import java.util.List;
import java.util.Map;

@Slf4j
public class DumperDoris implements IBusiSender<DumpEvent> {
	private final DorisConfig dorisConfig;
	private final DorisStreamLoad dorisStreamLoad;

	public DumperDoris() {
		this.dorisConfig = DorisAssit.initDefaultConfig();
		this.dorisStreamLoad = new DorisStreamLoad(dorisConfig);
	}

	@Override
	public void init(Dump dump) {
		String[] dbtb = dump.getBusiPluginConfig().getString(RuleItem.dbtb.name()).split("\\.");
		dorisConfig.setDb(dbtb[0]);
		dorisConfig.setTb(dbtb[1]);
	}

	@Override
	public void initParams(JSONObject params) {

	}

	@Override
	public void doSend(DumpEvent dumpEvent) {
//		String dataList = "[{\"name\":\"kk2\",\"id\":\"21\"},{\"id\":22,\"name\":\"k,k4\"}]";
		log.info("数据来了"+dumpEvent.getDatas().size());
		StopWatch sw = new StopWatch();
		sw.start("doris-dump-start");
		try {
			List<Map<String, String>> dataList = dumpEvent.getDatas();
			dorisStreamLoad.loadJsonArrayAppend(JSONUtil.toJsonStr(dataList));
		} catch (Exception e) {
			log.error("dump stream load error",e);
			throw new ProjectExceptionRuntime(ExceptAll.Project_default,e);
		}
		sw.stop();
		log.info(sw.getLastTaskName()+":"+sw.getTotalTimeMillis());
	}


}




