package net.wicp.tams.common.doris.constant;

import com.google.common.collect.Lists;
import com.mysql.jdbc.exceptions.jdbc4.MySQLSyntaxErrorException;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;

import javax.sql.DataSource;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * doris jdbc load
 */
@Slf4j
public class DorisTaskTest {
    private static final String checkBatchDeleteColumn = "__DORIS_DELETE_SIGN__";


    public static DataSource prestoDataSource() {
        return DataSourceBuilder.create().url("jdbc:mysql://192.168.32.247:3306/test")
                .username("iwin")
                .password("RrN2L5aUTHiAjO5Z")
                .driverClassName("com.mysql.jdbc.Driver")
                .type(HikariDataSource.class)
                .build();
    }

    public static JdbcTemplate dorisJdbcTemplate(DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    public static void main(String[] args) {
//        insertDatas();
//        updateTable();

    }

    public static void insertDatas() {
        JdbcTemplate jdbcTemplate = dorisJdbcTemplate(prestoDataSource());
        AtomicInteger i = new AtomicInteger(1);

        String insertStr = "INSERT INTO `test`.`user_info`(`name`, `age`, `birthday`, `money`, `update_time`, `create_time`) VALUES (";
        String nameValueStr = "张三丰";
        String otherStr = ", 33, '2021-10-25', 22, '2021-10-25 14:01:31', '2021-10-25 14:01:34.000');\n";


        // 计时器
        Timer timer = new Timer();

        TimerTask timerTask = new TimerTask() {
            @Override
            public void run() {
                StringBuilder sql = new StringBuilder("");
                sql.append(insertStr).append("'").append(nameValueStr).append(i.incrementAndGet()).append("'").append(otherStr);
                jdbcTemplate.update(sql.toString());
                if(i.get() == 10){
                    this.cancel();
                    timer.cancel();
                }
            }
        };
        // 添加执行任务(延迟 1s 执行，每 3s 执行一次)
        timer.schedule(timerTask, 100, 500);
    }

    public static void updateTable() {
        AtomicInteger i = new AtomicInteger(1);
        JdbcTemplate jdbcTemplate = dorisJdbcTemplate(prestoDataSource());
        String alterStr = "ALTER TABLE `test`.`user_info` \n" +
                "ADD COLUMN ";
        String columnNameStr = " k";
        String typeStr = " varchar(255) NULL;";

        // 计时器
        Timer timer = new Timer();

        TimerTask timerTask = new TimerTask() {
            @Override
            public void run() {
                if(i.get() == 3){
                    this.cancel();
                    timer.cancel();
                }

                StringBuilder sql = new StringBuilder("");
                sql.append(alterStr).append(columnNameStr).append(i.incrementAndGet()).append(typeStr);
                jdbcTemplate.update(sql.toString());

            }
        };
        // 添加执行任务(延迟 1s 执行，每 3s 执行一次)
        timer.schedule(timerTask, 300, 3000);


    }

}