package net.wicp.tams.common.doris.constant;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.doris.bean.DorisConfig;

import java.util.HashSet;
import java.util.Set;

public abstract class DorisAssit {
	static {
		// 防止自定义classload的时错过默认的加载配置,再次加载配置文件,不覆盖已存在的项
		Conf.overConf("/common-doris.properties", DorisAssit.class, false);
	}

	public static String getConfigValue(String confName) {
		String conf = Conf.get(String.format("common.doris.server.%s", confName));
		if ("default".equalsIgnoreCase(confName) || StringUtil.isNull(conf)) {
			conf = Conf.get(String.format("common.doris.server.%s.%s", "default" , confName));
		}
		return conf;
	}

	public static DorisConfig initDefaultConfig() {
		DorisConfig config = new DorisConfig();
		config.setHost(getConfigValue( "host"));
		config.setUsername(getConfigValue( "username"));
		config.setPassword(getConfigValue( "password"));
		config.setDb(getConfigValue( "db"));
		config.setTb(getConfigValue( "tb"));
		config.setHttpPort(getConfigValue("httpPort"));
		config.setJdbcPort(getConfigValue("jdbcPort"));
		config.setTimeout(getConfigValue("timeout"));
		config.setSqlRetryTimes(Integer.parseInt(getConfigValue("sqlRetryTimes")));
		return config;
	}


}
