/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.UUIDGenerator;
import net.wicp.tams.common.connector.ConfigInstance;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.beans.CusDynaClass;
import net.wicp.tams.common.connector.beans.property.AbstractDynaClassProperty;
import net.wicp.tams.common.connector.beans.property.DynaBeanHandler;
import net.wicp.tams.common.connector.constant.ColGType;
import net.wicp.tams.common.connector.constant.ColProperty;
import net.wicp.tams.common.connector.constant.ColType;
import net.wicp.tams.common.connector.constant.optColType.ParserDynaClassProperty;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.IProjectException;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.exception.param.Response;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigClass {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConfigClass.class);
    private String className;
    private CusDynaClass outDynaClass = null;
    private CusDynaClass inDynaClass = null;
    protected static final Map<String, AbstractConfigClass> parseClassMap = new HashMap<String, AbstractConfigClass>();

    public static void addPaseClass(String appkey, AbstractConfigClass classz) {
        parseClassMap.put(appkey, classz);
    }

    public static void clearCache() {
        parseClassMap.clear();
    }

    public static void delCache(String className) {
        parseClassMap.remove(className);
    }

    public AbstractConfigClass(String className) {
        this.className = className;
    }

    public abstract List<Map<ColProperty, String>> createColPropertyByRoot(String var1);

    public abstract List<Map<ColProperty, String>> createColPropertyByPath(String var1);

    private AbstractDynaClassProperty ParserParaProperty(Map<ColProperty, String> inputMap) throws ProjectException {
        String typeStr = inputMap.get((Object)ColProperty.type);
        ColType type = ColType.getByName(typeStr);
        ParserDynaClassProperty parser = new ParserDynaClassProperty();
        Result ret = null;
        if (type == ColType.dynaBean) {
            CusDynaClass retClass = this.createDynaClassByPath(inputMap.get((Object)ColProperty.name), inputMap.get((Object)ColProperty.xpath));
            ret = parser.opt(type, inputMap, retClass);
        } else {
            ret = parser.opt(type, inputMap);
        }
        if (ret == null) {
            String info = String.format("\u4e0d\u652f\u6301\u7684\u7c7b\u578b,\u5b57\u6bb5\u540d\uff1a[%s],\u7c7b\u578b\uff1a[%s]", inputMap.get((Object)ColProperty.name), typeStr);
            logger.error(info);
            throw new RuntimeException(info);
        }
        AbstractDynaClassProperty returnPropery = ret.isSuc() ? (AbstractDynaClassProperty)ret.retObjs(0) : null;
        return returnPropery;
    }

    private final synchronized CusDynaClass parserInput() throws ProjectException {
        if (this.inDynaClass == null) {
            CusDynaClass useDynaClass = this.createDynaClassCommon("PropertyIn");
            AbstractDynaClassProperty[] propertyAry = useDynaClass.getDynaProperties();
            AbstractDynaClassProperty[] newPropertyAry = new AbstractDynaClassProperty[propertyAry.length + 1];
            System.arraycopy(propertyAry, 0, newPropertyAry, 0, propertyAry.length);
            DynaBeanHandler ControlInfo = new DynaBeanHandler("ControlInfo", (DynaClass)ConfigInstance.getInstance().getInputClass());
            ControlInfo.putAttribute(ColProperty.gtype, ColGType.single.name());
            ControlInfo.putAttribute(ColProperty.strict, "false");
            newPropertyAry[propertyAry.length] = ControlInfo;
            this.inDynaClass = CusDynaClass.createCusDynaClass(this.getClassNameByNodeName("PropertyIn"), newPropertyAry);
        }
        return this.inDynaClass;
    }

    public final CusDynaClass parserInputNoCI() throws ProjectException {
        return this.createDynaClassCommon("PropertyIn");
    }

    public final CusDynaBean newInputBean(CusDynaBean clientBean) {
        try {
            CusDynaBean retDynaBean = this.parserInput().newInstance();
            if (clientBean == null) {
                return retDynaBean;
            }
            retDynaBean.set("ControlInfo", (Object)clientBean);
            return retDynaBean;
        }
        catch (Exception e) {
            logger.error(String.format("\u52a8\u6001\u7c7b%s\u65b0\u5efaInputBean\u5b9e\u4f8b\u51fa\u9519", this.className), (Throwable)e);
            return null;
        }
    }

    public final CusDynaBean newInputBean() {
        CusDynaBean clientBean = ConfigInstance.getInstance().newControlInfo();
        return this.newInputBean(clientBean);
    }

    public final CusDynaBean newInputBean(Properties inputobj) {
        CusDynaBean clientBean = ConfigInstance.getInstance().newControlInfo(inputobj);
        return this.newInputBean(clientBean);
    }

    public final CusDynaBean newInputBean(Map<String, String> inputobj) {
        CusDynaBean clientBean = ConfigInstance.getInstance().newControlInfo(inputobj);
        return this.newInputBean(clientBean);
    }

    private final synchronized CusDynaClass parserOut() throws ProjectException {
        if (this.outDynaClass == null) {
            CusDynaClass useDynaClass = this.createDynaClassCommon("PropertyOut");
            CusDynaClass addclass = ConfigInstance.getInstance().getOutClass();
            AbstractDynaClassProperty[] addprops = addclass.getDynaProperties();
            AbstractDynaClassProperty[] oriProps = useDynaClass.getDynaProperties();
            AbstractDynaClassProperty[] newPropertyAry = new AbstractDynaClassProperty[oriProps.length + addprops.length];
            System.arraycopy(oriProps, 0, newPropertyAry, 0, oriProps.length);
            System.arraycopy(addprops, 0, newPropertyAry, oriProps.length, addprops.length);
            this.outDynaClass = CusDynaClass.createCusDynaClass(this.getClassNameByNodeName("PropertyOut"), newPropertyAry);
        }
        return this.outDynaClass;
    }

    public final CusDynaBean newOutBean(IExcept exceptAll, String msgId) {
        try {
            CusDynaBean retBean = this.parserOut().newInstance();
            CusDynaBean respInfoBean = ConfigInstance.getInstance().newRespInfo(msgId);
            retBean.set(Response.respInfo.toString(), (Object)respInfoBean);
            exceptAll = exceptAll == null ? ExceptAll.no : exceptAll;
            retBean.set("errorValue", exceptAll.getErrorValue());
            retBean.set("errorCode", exceptAll.getErrorCode());
            retBean.set("errMsg", exceptAll.getErrMsg());
            retBean.set("errorDesc", exceptAll.getDesc());
            retBean.set("http", exceptAll.getHttp());
            return retBean;
        }
        catch (ProjectException e) {
            logger.error(String.format("\u52a8\u6001\u7c7b%s\u65b0\u5efaOutBean\u5b9e\u4f8b\u51fa\u9519", this.className), (Throwable)e);
            return null;
        }
    }

    public final CusDynaBean newOutBean(IExcept except) {
        return this.newOutBean(except, null);
    }

    public final CusDynaBean newOutBean(IProjectException except, String msgId) {
        try {
            IExcept exceptAll = except.getExcept();
            CusDynaBean retBean = this.parserOut().newInstance();
            CusDynaBean respInfoBean = ConfigInstance.getInstance().newRespInfo(msgId);
            retBean.set(Response.respInfo.toString(), (Object)respInfoBean);
            exceptAll = exceptAll == null ? ExceptAll.no : exceptAll;
            retBean.set("errorValue", exceptAll.getErrorValue());
            retBean.set("errorCode", exceptAll.getErrorCode());
            retBean.set("errMsg", exceptAll.getErrMsg());
            retBean.set("errorDesc", except.getMessage());
            retBean.set("http", exceptAll.getHttp());
            return retBean;
        }
        catch (ProjectException e) {
            logger.error(String.format("\u52a8\u6001\u7c7b%s\u65b0\u5efaOutBean\u5b9e\u4f8b\u51fa\u9519", this.className), (Throwable)e);
            return null;
        }
    }

    public final CusDynaBean newOutBean(ProjectException except) {
        return this.newOutBean((IProjectException)except, null);
    }

    public final CusDynaBean newOutBean(ProjectExceptionRuntime except) {
        return this.newOutBean((IProjectException)except, null);
    }

    public final CusDynaBean newOutSuc(String msgId) {
        return this.newOutBean((IExcept)ExceptAll.no, msgId);
    }

    public final CusDynaBean newOutSuc() {
        return this.newOutSuc(null);
    }

    public final synchronized CusDynaClass parserOutNoCI() throws ProjectException {
        return this.createDynaClassCommon("PropertyOut");
    }

    public final CusDynaBean newOutputBean() throws ProjectException {
        try {
            CusDynaClass tempClass = this.parserOut();
            return tempClass.newInstance();
        }
        catch (Exception e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "\u65b0\u5efa\u52a8\u6001Bean\u5b9e\u4f8b\u51fa\u9519");
        }
    }

    public static void setDefaultColProperty(Map<ColProperty, String> attributesOri) {
        String valueName;
        String namevalue = attributesOri.get((Object)ColProperty.name);
        String aliasvalue = attributesOri.get((Object)ColProperty.alias);
        if (StringUtils.isBlank((CharSequence)namevalue) && StringUtils.isBlank((CharSequence)aliasvalue)) {
            throw new IllegalArgumentException("name\u4e0ealias\u4e24\u4e2a\u5c5e\u6027\u5fc5\u987b\u8bbe\u7f6e\u5176\u4e2d\u4e00\u4e2a" + attributesOri);
        }
        if (StringUtils.isBlank((CharSequence)namevalue)) {
            attributesOri.put(ColProperty.name, aliasvalue);
        }
        if (StringUtils.isBlank((CharSequence)aliasvalue)) {
            attributesOri.put(ColProperty.alias, namevalue);
        }
        if (StringUtils.isBlank((CharSequence)(valueName = attributesOri.get((Object)ColProperty.valueName)))) {
            attributesOri.put(ColProperty.valueName, namevalue);
        }
        for (ColProperty colProperty : ColProperty.values()) {
            String tempValue;
            if (colProperty.equals((Object)ColProperty.xpath) || !StringUtils.isBlank((CharSequence)(tempValue = attributesOri.get((Object)colProperty))) || !StringUtils.isNotBlank((CharSequence)colProperty.getDefaultSelStringValue())) continue;
            attributesOri.put(colProperty, colProperty.getDefaultSelStringValue());
        }
    }

    public CusDynaClass createNewClass(CusDynaClass oldclass, String nodeName, List<Map<ColProperty, String>> colPropertys) throws ProjectException {
        if (CollectionUtils.isEmpty(colPropertys)) {
            return oldclass;
        }
        AbstractDynaClassProperty[] propertyAry = null;
        if (CollectionUtils.isNotEmpty(colPropertys)) {
            propertyAry = new AbstractDynaClassProperty[colPropertys.size()];
            for (int i = 0; i < colPropertys.size(); ++i) {
                Map<ColProperty, String> tempMap = colPropertys.get(i);
                propertyAry[i] = this.ParserParaProperty(tempMap);
            }
        }
        AbstractDynaClassProperty[] propertyAryold = oldclass.getDynaProperties();
        if (StringUtils.isBlank((CharSequence)nodeName)) {
            AbstractDynaClassProperty[] propertyArynew = new AbstractDynaClassProperty[propertyAryold.length + propertyAry.length];
            System.arraycopy(propertyAryold, 0, propertyArynew, 0, propertyAryold.length);
            System.arraycopy(propertyAry, 0, propertyArynew, propertyAryold.length, propertyAry.length);
            return CusDynaClass.createCusDynaClass(oldclass.getName(), propertyArynew);
        }
        CusDynaClass tempclass = CusDynaClass.createCusDynaClass(String.valueOf(UUIDGenerator.getUniqueLong()), propertyAry);
        DynaBeanHandler ControlInfo = new DynaBeanHandler(nodeName, (DynaClass)tempclass);
        ControlInfo.putAttribute(ColProperty.gtype, ColGType.single.name());
        ControlInfo.putAttribute(ColProperty.strict, "false");
        AbstractDynaClassProperty[] propertyArynew = new AbstractDynaClassProperty[propertyAryold.length + 1];
        System.arraycopy(propertyAryold, 0, propertyArynew, 0, propertyAryold.length);
        propertyArynew[propertyAryold.length] = ControlInfo;
        return CusDynaClass.createCusDynaClass(oldclass.getName(), propertyArynew);
    }

    private CusDynaClass createUtil(String nodeName, List<Map<ColProperty, String>> colProperty) throws ProjectException {
        AbstractDynaClassProperty[] propertyAry = null;
        if (CollectionUtils.isNotEmpty(colProperty)) {
            propertyAry = new AbstractDynaClassProperty[colProperty.size()];
            for (int i = 0; i < colProperty.size(); ++i) {
                Map<ColProperty, String> tempMap = colProperty.get(i);
                propertyAry[i] = this.ParserParaProperty(tempMap);
            }
        }
        return CusDynaClass.createCusDynaClass(nodeName, propertyAry);
    }

    private CusDynaClass createDynaClassCommon(String nodeName) throws ProjectException {
        List<Map<ColProperty, String>> colProperty = this.createColPropertyByRoot(nodeName);
        if (CollectionUtils.isEmpty(colProperty)) {
            logger.error("\u6ca1\u6709\u627e\u5230\u8be5\u8282\u70b9[{}]", (Object)nodeName);
        } else {
            for (final Map<ColProperty, String> map : colProperty) {
                List retlist;
                String type = map.get((Object)ColProperty.type);
                ColType temptype = ColType.getByName(type);
                if (!ArrayUtils.isNotEmpty((Object[])temptype.getNeedCols()) || !CollectionUtils.isNotEmpty((Collection)(retlist = (List)CollectionUtils.select(Arrays.asList(temptype.getNeedCols()), (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        ColProperty temobj = (ColProperty)((Object)object);
                        return !map.containsKey((Object)temobj) || StringUtils.isBlank((CharSequence)((CharSequence)map.get((Object)temobj)));
                    }
                })))) continue;
                logger.error("\u914d\u7f6e\u6587\u4ef6\u9519\u8bef\uff0c\u5b57\u6bb5[{}->{}],\u9700\u8981\u51fa\u73b0\u4e0b\u5217\u914d\u7f6e\u9879[{}]\u5374\u6ca1\u6709\u51fa\u73b0", new Object[]{nodeName, map.get((Object)ColProperty.name), CollectionUtil.listJoin((Collection)retlist, (String)",")});
                throw new ProjectException((IExcept)ExceptAll.param_error);
            }
        }
        return this.createUtil(nodeName, colProperty);
    }

    private CusDynaClass createDynaClassByPath(String nodeName, String nodePath) throws ProjectException {
        List<Map<ColProperty, String>> colProperty = this.createColPropertyByPath(nodePath);
        return this.createUtil(nodeName, colProperty);
    }

    private String getClassNameByNodeName(String nodeName) {
        return this.className + "_" + nodeName;
    }

    private Map<ColProperty, String> packColMap(String name, String alias, boolean isnull, ColGType gtype, ColType type, String defaultValue, Integer length, String max, String min, String format, String className) {
        HashMap<ColProperty, String> sysColPro_result = new HashMap<ColProperty, String>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            sysColPro_result.put(ColProperty.name, name);
        }
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            sysColPro_result.put(ColProperty.alias, StringUtils.isBlank((CharSequence)alias) ? name : alias);
        }
        sysColPro_result.put(ColProperty.isnull, String.valueOf(isnull));
        if (gtype != null) {
            sysColPro_result.put(ColProperty.gtype, gtype.name());
        } else {
            sysColPro_result.put(ColProperty.gtype, ColGType.single.name());
        }
        if (type != null) {
            sysColPro_result.put(ColProperty.type, type.name());
        }
        if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
            sysColPro_result.put(ColProperty.defaultValue, defaultValue);
        }
        if (length != null) {
            sysColPro_result.put(ColProperty.length, String.valueOf(length));
        }
        if (max != null) {
            sysColPro_result.put(ColProperty.max, max);
        }
        if (min != null) {
            sysColPro_result.put(ColProperty.min, min);
        }
        if (StringUtils.isNotBlank((CharSequence)format)) {
            sysColPro_result.put(ColProperty.format, format);
        }
        if (StringUtils.isNotBlank((CharSequence)className)) {
            sysColPro_result.put(ColProperty.className, className);
        }
        return sysColPro_result;
    }
}

