/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.beans.property;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Iterator;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.beans.CusDynaClass;
import net.wicp.tams.common.connector.beans.property.AbstractDynaClassProperty;
import net.wicp.tams.common.connector.beans.property.BasicNoHandler;
import net.wicp.tams.common.connector.constant.ColProperty;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynaBeanHandler
extends BasicNoHandler {
    private static final Logger log = LoggerFactory.getLogger(DynaBeanHandler.class);
    private static final long serialVersionUID = 1L;
    private CusDynaClass valueClass;

    public CusDynaClass getValueClass() {
        return this.valueClass;
    }

    public DynaBeanHandler(String name, DynaClass valueClass) {
        super(name, valueClass);
        this.valueClass = (CusDynaClass)valueClass;
    }

    public DynaBeanHandler(String name, Class type, DynaClass valueClass) {
        super(name, type, valueClass.getClass());
        this.valueClass = (CusDynaClass)valueClass;
    }

    @Override
    protected Result checkSingleValue(Object value) {
        if (value == null) {
            return Result.getSuc();
        }
        String strict = this.getAttributeValue(ColProperty.strict);
        boolean isStrict = true;
        if (StringUtils.isNotBlank((CharSequence)strict)) {
            isStrict = Boolean.parseBoolean(strict);
        }
        boolean isSame = false;
        isSame = isStrict ? ((CusDynaBean)((Object)value)).getDynaClass() == this.valueClass : this.isSameClass(value);
        if (!isSame) {
            log.error("[{}]\u7684\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5e94\u8be5\u662fCusDynaClass,\u4f46\u4f20\u8fdb\u6765\u7684\u53c2\u6570\u662f[{}]\u7c7b\u578b", (Object)this.name, (Object)value.getClass().getName());
            return new Result((IExcept)ExceptAll.Param_typenofit);
        }
        return Result.getSuc();
    }

    private boolean isSameClass(Object value) {
        HashMap<String, AbstractDynaClassProperty> thisProps = this.valueClass.getAllPropertys();
        AbstractDynaClassProperty[] valProps = ((CusDynaBean)((Object)value)).getDynaClass().getDynaProperties();
        if (thisProps.size() != valProps.length) {
            return false;
        }
        boolean ret = true;
        for (AbstractDynaClassProperty valprop : valProps) {
            if (thisProps.keySet().contains(valprop.getName())) continue;
            ret = false;
            break;
        }
        return ret;
    }

    @Override
    protected Object jsonTosingleObj(Object obj) {
        ObjectNode retobj = (ObjectNode)obj;
        CusDynaBean dynabean = this.valueClass.newInstance();
        Iterator iterator = retobj.fieldNames();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            AbstractDynaClassProperty prop = (AbstractDynaClassProperty)dynabean.getDynaClass().getDynaProperty(key);
            if (prop == null) continue;
            prop.setValueByJson(dynabean, retobj.get(key));
        }
        return dynabean;
    }

    @Override
    public Object getSingleDefaultColValue() {
        String defaultValue = this.getAttriValue(ColProperty.defaultValue);
        if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
            ObjectNode json = (ObjectNode)JSONUtil.parserStr((ObjectMapper)new ObjectMapper(), (String)defaultValue);
            CusDynaBean db = (CusDynaBean)((Object)this.jsonTosingleObj(json));
            return db;
        }
        return null;
    }

    @Override
    protected Object singleObjToJson(Object singleValue) {
        AbstractDynaClassProperty[] props;
        if (singleValue == null) {
            return null;
        }
        ObjectNode retobj = JsonNodeFactory.instance.objectNode();
        CusDynaBean cus = (CusDynaBean)((Object)singleValue);
        for (AbstractDynaClassProperty prop : props = cus.getDynaClass().getDynaProperties()) {
            Object propValue = cus.get(prop.getName());
            retobj.putPOJO(prop.getName(), prop.singleObjToJson(propValue));
        }
        return retobj;
    }

    @Override
    protected Object mockObj() {
        CusDynaBean dynabean = this.valueClass.newInstance();
        HashMap<String, AbstractDynaClassProperty> allPropertys = this.valueClass.getAllPropertys();
        for (String key : allPropertys.keySet()) {
            AbstractDynaClassProperty prop = (AbstractDynaClassProperty)dynabean.getDynaClass().getDynaProperty(key);
            prop.setValueByMock(dynabean);
        }
        return dynabean;
    }
}

