/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.connector.beans.property;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.beans.property.BasicHandler;
import net.wicp.tams.common.connector.callback.OptAbsGType;
import net.wicp.tams.common.connector.constant.ColGType;
import net.wicp.tams.common.connector.constant.ColProperty;
import net.wicp.tams.common.connector.constant.ColType;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynaClassProperty
extends DynaProperty
implements Cloneable {
    private static final long serialVersionUID = -5474164260071583692L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractDynaClassProperty.class);
    protected final Map<ColProperty, String> attributes = new HashMap<ColProperty, String>();

    public AbstractDynaClassProperty(String name) {
        super(name);
    }

    public AbstractDynaClassProperty(String name, Class type) {
        super(name, type);
    }

    public AbstractDynaClassProperty(String name, Class type, Class contentType) {
        super(name, type, contentType);
    }

    protected abstract Result checkSingleValue(Object var1);

    public Result checkValue(Object value) {
        CheckPropertyValue checkobj = new CheckPropertyValue();
        Result result = checkobj.opt(this.getGType(), value);
        return result;
    }

    protected abstract Object singleObjToJson(Object var1);

    protected abstract Object jsonTosingleObj(Object var1);

    protected abstract Object mockObj();

    public ObjectNode getJsonObj(CusDynaBean dynaBean) {
        PackJson packobj = new PackJson();
        Result res = packobj.opt(this.getGType(), new Object[]{dynaBean});
        Object retobj = null;
        if (res.isSuc()) {
            retobj = res.retObjs(0);
            ObjectNode json = JsonNodeFactory.instance.objectNode();
            json.putPOJO(this.name, retobj);
            return json;
        }
        return null;
    }

    public void setValueByJson(CusDynaBean dynaBean, Object json) {
        PutJson putobj = new PutJson(json);
        Result res = putobj.opt(this.getGType(), new Object[]{dynaBean});
        if (!res.isSuc()) {
            logger.error("\u8bbe\u7f6e\u52a8\u6001Bean\u503c\u51fa\u9519\uff0c\u539f\u56e0\uff1a{}", (Object)res.getMessage());
        }
    }

    public void setValueByMock(CusDynaBean dynaBean) {
        MockData putobj = new MockData();
        Result res = putobj.opt(this.getGType(), new Object[]{dynaBean});
        if (!res.isSuc()) {
            logger.error("\u8bbe\u7f6e\u52a8\u6001Bean\u7684mock\u503c\u51fa\u9519\uff0c\u539f\u56e0\uff1a{}", (Object)res.getMessage());
        }
    }

    public abstract Object getSingleDefaultColValue();

    public void setDefaultColValue(CusDynaBean dynaBean) {
        Object defaultValue;
        if (StringUtils.isNotBlank((CharSequence)this.getAttriValue(ColProperty.defaultValue)) && this.getGType() == ColGType.single && (defaultValue = this.getSingleDefaultColValue()) != null) {
            dynaBean.set(this.name, defaultValue);
        }
    }

    public String getAttriValue(ColProperty attname) {
        if (attname == null) {
            return null;
        }
        return this.attributes.get((Object)attname);
    }

    public ColGType getGType() {
        String gType = this.getAttriValue(ColProperty.gtype);
        return ColGType.getByName(gType);
    }

    public boolean isNull() {
        String isnullStr = this.getAttriValue(ColProperty.isnull);
        return Boolean.parseBoolean(isnullStr);
    }

    public void putAttributes(Map<ColProperty, String> attributes) {
        this.attributes.putAll(attributes);
    }

    public void putAttribute(ColProperty colProperty, String value) {
        if (colProperty == null) {
            return;
        }
        this.attributes.put(colProperty, value);
    }

    public void putAttribute(String attname, String value) {
        ColProperty findCol = ColProperty.getByName(attname);
        this.putAttribute(findCol, value);
    }

    public Map<ColProperty, String> getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(ColProperty attname) {
        if (attname == null) {
            return null;
        }
        return this.attributes.get((Object)attname);
    }

    public String getAttributeValue(String attname) {
        ColProperty findCol = ColProperty.getByName(attname);
        return this.getAttributeValue(findCol);
    }

    private class MockData
    extends OptAbsGType {
        private MockData() {
        }

        @Override
        protected Result doSingle(Object param) {
            CusDynaBean inputBean = (CusDynaBean)((Object)param);
            Object valobj = AbstractDynaClassProperty.this.mockObj();
            inputBean.set(AbstractDynaClassProperty.this.name, valobj);
            return Result.getSuc();
        }

        @Override
        protected Result doArray(Object param) {
            CusDynaBean inputBean = (CusDynaBean)((Object)param);
            String typestr = AbstractDynaClassProperty.this.getAttriValue(ColProperty.type);
            if ("string".equals(typestr)) {
                String[] retAry = new String[1];
                for (int i = 0; i < retAry.length; ++i) {
                    Object valobj = AbstractDynaClassProperty.this.mockObj();
                    retAry[i] = String.valueOf(valobj);
                }
                inputBean.set(AbstractDynaClassProperty.this.name, retAry);
            } else if ("integer".equals(typestr)) {
                Integer[] retAry = new Integer[1];
                for (int i = 0; i < retAry.length; ++i) {
                    Object valobj = AbstractDynaClassProperty.this.mockObj();
                    retAry[i] = Integer.getInteger(String.valueOf(valobj));
                }
                inputBean.set(AbstractDynaClassProperty.this.name, retAry);
            } else if ("enums".equals(typestr)) {
                Enum[] retAry = new Enum[1];
                for (int i = 0; i < retAry.length; ++i) {
                    Enum valobj;
                    retAry[i] = valobj = (Enum)AbstractDynaClassProperty.this.mockObj();
                }
                inputBean.set(AbstractDynaClassProperty.this.name, retAry);
            } else {
                Object[] retAry = new Object[1];
                for (int i = 0; i < retAry.length; ++i) {
                    Object valobj;
                    retAry[i] = valobj = AbstractDynaClassProperty.this.mockObj();
                }
                inputBean.set(AbstractDynaClassProperty.this.name, retAry);
            }
            return Result.getSuc();
        }

        @Override
        protected Result doMap(Object param) {
            CusDynaBean inputBean = (CusDynaBean)((Object)param);
            HashMap<String, Object> mockmap = new HashMap<String, Object>();
            mockmap.put("mockKey", AbstractDynaClassProperty.this.mockObj());
            inputBean.set(AbstractDynaClassProperty.this.name, mockmap);
            return Result.getSuc();
        }

        @Override
        protected Result doList(Object param) {
            CusDynaBean inputBean = (CusDynaBean)((Object)param);
            ArrayList<Object> mocklist = new ArrayList<Object>();
            mocklist.add(AbstractDynaClassProperty.this.mockObj());
            inputBean.set(AbstractDynaClassProperty.this.name, mocklist);
            return Result.getSuc();
        }
    }

    private class PutJson
    extends OptAbsGType {
        private final Object obj;

        public PutJson(Object json) {
            this.obj = json instanceof BasicHandler ? json : json;
        }

        @Override
        protected Result doSingle(Object param) {
            CusDynaBean inputBean = (CusDynaBean)((Object)param);
            Object valobj = AbstractDynaClassProperty.this.jsonTosingleObj(this.obj);
            inputBean.set(AbstractDynaClassProperty.this.name, valobj);
            return Result.getSuc();
        }

        @Override
        protected Result doArray(Object param) {
            CusDynaBean inputBean = (CusDynaBean)((Object)param);
            JSONArray arry = (JSONArray)this.obj;
            String typestr = AbstractDynaClassProperty.this.getAttriValue(ColProperty.type);
            try {
                if ("string".equals(typestr)) {
                    String[] retAry = new String[arry.length()];
                    for (int i = 0; i < retAry.length; ++i) {
                        Object valobj = AbstractDynaClassProperty.this.jsonTosingleObj(arry.get(i));
                        retAry[i] = String.valueOf(valobj);
                    }
                    inputBean.set(AbstractDynaClassProperty.this.name, retAry);
                } else if ("integer".equals(typestr)) {
                    Integer[] retAry = new Integer[arry.length()];
                    for (int i = 0; i < retAry.length; ++i) {
                        Object valobj = AbstractDynaClassProperty.this.jsonTosingleObj(arry.get(i));
                        retAry[i] = Integer.getInteger(String.valueOf(valobj));
                    }
                    inputBean.set(AbstractDynaClassProperty.this.name, retAry);
                } else if ("enums".equals(typestr)) {
                    Enum[] retAry = new Enum[arry.length()];
                    for (int i = 0; i < retAry.length; ++i) {
                        Enum valobj;
                        retAry[i] = valobj = (Enum)AbstractDynaClassProperty.this.jsonTosingleObj(arry.get(i));
                    }
                    inputBean.set(AbstractDynaClassProperty.this.name, retAry);
                } else {
                    Object[] retAry = new Object[arry.length()];
                    for (int i = 0; i < retAry.length; ++i) {
                        Object valobj;
                        retAry[i] = valobj = AbstractDynaClassProperty.this.jsonTosingleObj(arry.get(i));
                    }
                    inputBean.set(AbstractDynaClassProperty.this.name, retAry);
                }
            }
            catch (Exception e) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, (Throwable)e);
            }
            return Result.getSuc();
        }

        @Override
        protected Result doMap(Object param) {
            CusDynaBean inputBean = (CusDynaBean)((Object)param);
            ObjectNode json = (ObjectNode)this.obj;
            String typestr = AbstractDynaClassProperty.this.getAttriValue(ColProperty.type);
            if ("string".equals(typestr)) {
                HashMap<String, String> retobj = new HashMap<String, String>();
                Iterator iterator = json.fieldNames();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Object valobj = AbstractDynaClassProperty.this.jsonTosingleObj(json.get(key));
                    retobj.put(key, String.valueOf(valobj));
                }
                inputBean.set(AbstractDynaClassProperty.this.name, retobj);
            } else if ("integer".equals(typestr)) {
                HashMap<String, Integer> retobj = new HashMap<String, Integer>();
                Iterator iterator = json.fieldNames();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Object valobj = AbstractDynaClassProperty.this.jsonTosingleObj(json.get(key));
                    retobj.put(key, Integer.parseInt(String.valueOf(valobj)));
                }
                inputBean.set(AbstractDynaClassProperty.this.name, retobj);
            } else if ("enums".equals(typestr)) {
                HashMap<String, Enum> retobj = new HashMap<String, Enum>();
                Iterator iterator = json.fieldNames();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Enum valobj = (Enum)AbstractDynaClassProperty.this.jsonTosingleObj(json.get(key));
                    retobj.put(key, valobj);
                }
                inputBean.set(AbstractDynaClassProperty.this.name, retobj);
            } else {
                HashMap<String, Object> retobj = new HashMap<String, Object>();
                Iterator iterator = json.fieldNames();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Object valobj = AbstractDynaClassProperty.this.jsonTosingleObj(json.get(key));
                    retobj.put(key, valobj);
                }
                inputBean.set(AbstractDynaClassProperty.this.name, retobj);
            }
            return Result.getSuc();
        }

        @Override
        protected Result doList(Object param) {
            CusDynaBean inputBean = (CusDynaBean)((Object)param);
            ArrayNode arry = (ArrayNode)this.obj;
            String typestr = AbstractDynaClassProperty.this.getAttriValue(ColProperty.type);
            if ("string".equals(typestr)) {
                ArrayList<String> retAry = new ArrayList<String>();
                for (int i = 0; i < retAry.size(); ++i) {
                    Object valobj = AbstractDynaClassProperty.this.jsonTosingleObj(arry.get(i));
                    retAry.add(String.valueOf(valobj));
                }
                inputBean.set(AbstractDynaClassProperty.this.name, retAry);
            } else if ("integer".equals(typestr)) {
                ArrayList<Integer> retAry = new ArrayList<Integer>();
                for (int i = 0; i < retAry.size(); ++i) {
                    Object valobj = AbstractDynaClassProperty.this.jsonTosingleObj(arry.get(i));
                    retAry.add(Integer.parseInt(String.valueOf(valobj)));
                }
                inputBean.set(AbstractDynaClassProperty.this.name, retAry);
            } else if ("enums".equals(typestr)) {
                ArrayList<Enum> retAry = new ArrayList<Enum>();
                for (int i = 0; i < retAry.size(); ++i) {
                    Enum valobj = (Enum)AbstractDynaClassProperty.this.jsonTosingleObj(arry.get(i));
                    retAry.add(valobj);
                }
                inputBean.set(AbstractDynaClassProperty.this.name, retAry);
            } else {
                ArrayList<Object> retAry = new ArrayList<Object>();
                for (int i = 0; i < retAry.size(); ++i) {
                    Object valobj = AbstractDynaClassProperty.this.jsonTosingleObj(arry.get(i));
                    retAry.add(valobj);
                }
                inputBean.set(AbstractDynaClassProperty.this.name, retAry);
            }
            return Result.getSuc();
        }
    }

    private class PackJson
    extends OptAbsGType {
        private PackJson() {
        }

        @Override
        protected Result doSingle(Object param) {
            if (param == null) {
                return Result.getError((String)"\u7a7a\u503c");
            }
            CusDynaBean dynaBean = (CusDynaBean)((Object)param);
            Object retobj = AbstractDynaClassProperty.this.singleObjToJson(dynaBean.get(AbstractDynaClassProperty.this.getName()));
            if (retobj == null) {
                return Result.getError((String)"\u7a7a\u503c");
            }
            Result ret = Result.getSuc();
            ret.setRetObjs(new Object[]{retobj});
            return ret;
        }

        @Override
        protected Result doArray(Object param) {
            if (param == null) {
                return Result.getError((String)"\u7a7a\u503c");
            }
            CusDynaBean dynaBean = (CusDynaBean)((Object)param);
            Object[] objary = (Object[])dynaBean.get(AbstractDynaClassProperty.this.name);
            if (objary == null || objary.length == 0) {
                return Result.getError((String)"\u7a7a\u503c");
            }
            AbstractDynaClassProperty dynaProperty = (AbstractDynaClassProperty)((CusDynaBean)((Object)param)).getDynaClass().getDynaProperty(AbstractDynaClassProperty.this.name);
            String typeStr = dynaProperty.getAttributeValue(ColProperty.type);
            JSONArray retary = new JSONArray();
            for (Object object : objary) {
                Object retobj = null;
                retobj = "javaBean".equals(typeStr) || "dynaBean".equals(typeStr) ? AbstractDynaClassProperty.this.singleObjToJson(object) : String.valueOf(object);
                retary.put(retobj);
            }
            Result ret = Result.getSuc();
            ret.setRetObjs((Object[])new JSONArray[]{retary});
            return ret;
        }

        @Override
        protected Result doMap(Object param) {
            if (param == null) {
                return Result.getError((String)"\u7a7a\u503c");
            }
            CusDynaBean dynaBean = (CusDynaBean)((Object)param);
            Map objmap = (Map)dynaBean.get(AbstractDynaClassProperty.this.name);
            if (MapUtils.isEmpty((Map)objmap)) {
                return Result.getError((String)"\u7a7a\u503c");
            }
            JSONObject retobj = new JSONObject();
            try {
                for (Object key : objmap.keySet()) {
                    if (objmap.get(key) instanceof CusDynaBean) {
                        retobj.put(String.valueOf(key), AbstractDynaClassProperty.this.singleObjToJson(objmap.get(key)));
                        continue;
                    }
                    retobj.put(String.valueOf(key), (Object)String.valueOf(objmap.get(key)));
                }
            }
            catch (Exception e) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u8f6c\u6362map\u5931\u8d25", (Throwable)e);
            }
            Result ret = Result.getSuc();
            ret.setRetObjs((Object[])new JSONObject[]{retobj});
            return ret;
        }

        @Override
        protected Result doList(Object param) {
            if (param == null) {
                return Result.getError((String)"\u7a7a\u503c");
            }
            CusDynaBean dynaBean = (CusDynaBean)((Object)param);
            List objlist = (List)dynaBean.get(AbstractDynaClassProperty.this.name);
            if (CollectionUtils.isEmpty((Collection)objlist)) {
                return Result.getError((String)"\u7a7a\u503c");
            }
            JSONArray retary = new JSONArray();
            for (Object obj : objlist) {
                retary.put(AbstractDynaClassProperty.this.singleObjToJson(obj));
            }
            Result ret = Result.getSuc();
            ret.setRetObjs((Object[])new JSONArray[]{retary});
            return ret;
        }
    }

    private class CheckPropertyValue
    extends OptAbsGType {
        int length;

        private CheckPropertyValue() {
            this.length = StringUtils.isBlank((CharSequence)AbstractDynaClassProperty.this.getAttriValue(ColProperty.length)) ? -1 : Integer.parseInt(AbstractDynaClassProperty.this.getAttriValue(ColProperty.length));
        }

        @Override
        protected Result doSingle(Object param) {
            return AbstractDynaClassProperty.this.checkSingleValue(param);
        }

        @Override
        protected Result doArray(Object param) {
            if (param != null && !param.getClass().isArray() || ColType.bytes.name().equals(AbstractDynaClassProperty.this.getAttriValue(ColProperty.type)) && param.getClass().isAssignableFrom(byte[].class)) {
                return this.doSingle(param);
            }
            Object[] values = (Object[])param;
            if (values == null || values.length == 0) {
                if (!AbstractDynaClassProperty.this.isNull()) {
                    String errmsg = String.format("[%s]\u4e0d\u5141\u8bb8\u4e3a\u7a7a", AbstractDynaClassProperty.this.name);
                    logger.error(errmsg);
                    return new Result(new ProjectException((IExcept)ExceptAll.Param_lengthover, errmsg));
                }
                return Result.getSuc();
            }
            if (this.length >= 0 && values.length > this.length) {
                String errmsg = String.format("\u8d8a\u754c[%s]\u957f\u5ea6\u4e3a\uff1a%s \u4f46\u662f\u4f20\u8fdb\u6765\u7684\u503c\u5927\u5c0f\u4e3a\uff1a%s", AbstractDynaClassProperty.this.name, this.length, values == null ? 0 : values.length);
                logger.error(errmsg);
                return new Result(new ProjectException((IExcept)ExceptAll.Param_lengthover, errmsg));
            }
            StringBuffer retbuff = new StringBuffer("");
            for (int i = 0; i < values.length; ++i) {
                Result rs = AbstractDynaClassProperty.this.checkSingleValue(values[i]);
                if (rs.isSuc()) continue;
                retbuff.append(String.format("\u7b2c[%s]\u4e2a\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u56e0\uff1a%s\n", i + 1, rs.getMessage()));
            }
            return this.retValue(retbuff);
        }

        private Result retValue(StringBuffer retbuff) {
            if (StringUtils.isBlank((CharSequence)retbuff.toString())) {
                return Result.getSuc();
            }
            retbuff.insert(0, "\u68c0\u67e5\u9519\u8bef\uff0c\u539f\u56e0\uff1a");
            return Result.getError((String)retbuff.toString());
        }

        @Override
        protected Result doMap(Object param) {
            if (param == null) {
                if (!AbstractDynaClassProperty.this.isNull()) {
                    String errmsg = String.format("[%s]\u4e0d\u5141\u8bb8\u4e3a\u7a7a", AbstractDynaClassProperty.this.name);
                    logger.error(errmsg);
                    return new Result(new ProjectException((IExcept)ExceptAll.Param_lengthover, errmsg));
                }
                return Result.getSuc();
            }
            if (!Map.class.isAssignableFrom(param.getClass())) {
                return this.doSingle(param);
            }
            Map tempValue = (Map)param;
            if (this.length >= 0 && tempValue.size() > this.length) {
                logger.error("\u8d8a\u754c[{}]\u957f\u5ea6\u4e3a\uff1a{} \u4f46\u662f\u4f20\u8fdb\u6765\u7684\u503c\u5927\u5c0f\u4e3a\uff1a", new Object[]{AbstractDynaClassProperty.this.name, this.length, tempValue.size()});
                return new Result((IExcept)ExceptAll.Param_lengthover);
            }
            StringBuffer retbuff = new StringBuffer("");
            for (String eleKey : tempValue.keySet()) {
                Result rs = AbstractDynaClassProperty.this.checkSingleValue(tempValue.get(eleKey));
                if (rs.isSuc()) continue;
                retbuff.append(String.format("\u53c2\u6570\uff1a{} \u4e0d\u5408\u6cd5\uff0c\u539f\u56e0\uff1a{},", eleKey, rs.getMessage()));
            }
            return this.retValue(retbuff);
        }

        @Override
        protected Result doList(Object param) {
            if (param == null) {
                if (!AbstractDynaClassProperty.this.isNull()) {
                    String errmsg = String.format("[%s]\u4e0d\u5141\u8bb8\u4e3a\u7a7a", AbstractDynaClassProperty.this.name);
                    logger.error(errmsg);
                    return new Result(new ProjectException((IExcept)ExceptAll.Param_lengthover, errmsg));
                }
                return Result.getSuc();
            }
            if (!List.class.isAssignableFrom(param.getClass())) {
                return this.doSingle(param);
            }
            List tempValue = (List)param;
            if (this.length >= 0 && tempValue.size() > this.length) {
                logger.error("\u8d8a\u754c[{}]\u957f\u5ea6\u4e3a\uff1a{} \u4f46\u662f\u4f20\u8fdb\u6765\u7684\u503c\u5927\u5c0f\u4e3a\uff1a", new Object[]{AbstractDynaClassProperty.this.name, this.length, tempValue.size()});
                return new Result((IExcept)ExceptAll.Param_lengthover);
            }
            StringBuffer retbuff = new StringBuffer("");
            for (int i = 0; i < tempValue.size(); ++i) {
                Object object = tempValue.get(i);
                Result rs = AbstractDynaClassProperty.this.checkSingleValue(object);
                if (rs.isSuc()) continue;
                retbuff.append(String.format("\u7b2c{}\u4e2a\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u56e0\uff1a{},", i + 1, rs.getMessage()));
            }
            return this.retValue(retbuff);
        }
    }
}

